/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.legacy.v12.m2.registry.item;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.item.ItemBuilderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.item.ItemProperties;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.item.ToolBuilderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.tab.CreativeTabAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.WrapperHelper;
import mods.thecomputerizer.theimpossiblelibrary.legacy.v12.m2.registry.item.TILCustomTool1_12_2;
import mods.thecomputerizer.theimpossiblelibrary.legacy.v12.m2.registry.item.TILItemAxe1_12_2;
import mods.thecomputerizer.theimpossiblelibrary.legacy.v12.m2.registry.item.TILItemHoe1_12_2;
import mods.thecomputerizer.theimpossiblelibrary.legacy.v12.m2.registry.item.TILItemPickaxe1_12_2;
import mods.thecomputerizer.theimpossiblelibrary.legacy.v12.m2.registry.item.TILItemShovel1_12_2;
import mods.thecomputerizer.theimpossiblelibrary.legacy.v12.m2.registry.item.TILItemSword1_12_2;
import net.minecraft.block.Block;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ToolBuilder1_12_2
extends ToolBuilderAPI {
    public ToolBuilder1_12_2(@Nullable ItemBuilderAPI builder, ItemBuilderAPI.ToolType type) {
        super(builder, type);
    }

    @Override
    public ItemAPI<?> build() {
        ItemProperties properties = this.buildProperties();
        Item item = this.getItem(properties, (Item.ToolMaterial)this.toolTier.unwrap());
        CreativeTabAPI<?> tab = properties.getCreativeTab();
        if (Objects.nonNull(tab)) {
            tab.addStack(() -> WrapperHelper.wrapItemStack(new ItemStack(item)));
        }
        if (CoreAPI.isClient()) {
            this.registerTextureProperties(item);
        }
        return WrapperHelper.wrapItem(item);
    }

    private Item getItem(ItemProperties properties, Item.ToolMaterial material) {
        switch (this.toolType) {
            case AXE: {
                return new TILItemAxe1_12_2(material, this.damageModifier, this.speedModifier, properties);
            }
            case HOE: {
                return new TILItemHoe1_12_2(material, properties);
            }
            case PICKAXE: {
                return new TILItemPickaxe1_12_2(material, properties);
            }
            case SHOVEL: {
                return new TILItemShovel1_12_2(material, properties);
            }
            case SWORD: {
                return new TILItemSword1_12_2(material, properties);
            }
        }
        HashSet<Block> blocks = new HashSet<Block>();
        this.effectiveBlocks.forEach(block -> blocks.add((Block)block.unwrap()));
        return new TILCustomTool1_12_2(this.damageModifier, this.speedModifier, material, blocks, properties);
    }

    private void registerTextureProperties(Item item) {
        for (Map.Entry property : this.propertyMap.entrySet()) {
            ResourceLocation location = (ResourceLocation)((ResourceLocationAPI)property.getKey()).unwrap();
            IItemPropertyGetter getter = (stack, world, entity) -> ((Float)((BiFunction)property.getValue()).apply(WrapperHelper.wrapItemStack(stack), WrapperHelper.wrapWorld(world))).floatValue();
            item.func_185043_a(location, getter);
        }
    }
}

