/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.legacy.v12.m2.core.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.annotation.Nullable;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModCandidate;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModInfo;
import mods.thecomputerizer.theimpossiblelibrary.legacy.core.loader.MultiversionLoaderLegacy;
import mods.thecomputerizer.theimpossiblelibrary.legacy.v12.m2.core.asm.ModContainerWriter1_12_2;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import net.minecraftforge.fml.relauncher.libraries.LibraryManager;

public class MultiVersionLoader1_12_2
extends MultiversionLoaderLegacy {
    public MultiVersionLoader1_12_2(CoreAPI parent) {
        super(parent);
    }

    @Override
    protected File findCoreModRoot() {
        return new File("mods");
    }

    @Override
    public File findModRoot() {
        return new File("mods");
    }

    @Override
    protected List<File> gatherCandidateModFiles(File root) {
        TILRef.logDebug("Gathering mod candidates from `{}`", root);
        File[] files = root.listFiles(file -> file.isFile() && file.getName().endsWith(".jar"));
        HashSet set = new HashSet(Objects.nonNull(files) ? Arrays.asList(files) : Collections.emptyList());
        for (Path path : this.potentialModPaths) {
            File file2 = path.toFile();
            if (!file2.isFile() || !file2.getName().endsWith(".jar")) continue;
            set.add(file2);
        }
        return Collections.unmodifiableList(new ArrayList(set));
    }

    @Override
    @Nullable
    protected Attributes getFileAttributes(File file) {
        Attributes attributes;
        if (Objects.isNull(file) || !file.exists()) {
            return null;
        }
        File manifestFile = new File(file.getAbsolutePath() + ".meta");
        if (LibraryManager.DISABLE_EXTERNAL_MANIFEST || !manifestFile.exists()) {
            Attributes attributes2;
            JarFile jar = new JarFile(file);
            try {
                Manifest manifest = jar.getManifest();
                attributes2 = Objects.nonNull(manifest) ? manifest.getMainAttributes() : null;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jar.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    TILRef.logError("Failed to get attributes from jar `{}`", file, ex);
                    return null;
                }
            }
            jar.close();
            return attributes2;
        }
        FileInputStream stream = new FileInputStream(manifestFile);
        try {
            attributes = new Manifest(stream).getMainAttributes();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            catch (IOException ex) {
                TILRef.logError("Failed to get attributes from file `{}`", file, ex);
                return null;
            }
        }
        stream.close();
        return attributes;
    }

    @Override
    protected MultiVersionModInfo loadModInfo(ClassLoader classLoader, MultiVersionModCandidate candidate, MultiVersionModInfo info) {
        FMLInjectionData.containers.add(ModContainerWriter1_12_2.writeModContainer((LaunchClassLoader)classLoader, info.getModID(), info.getContainerClasspath()));
        return info;
    }
}

