/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.legacy.v12.m2.core.asm;

import java.util.List;
import java.util.Map;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ModWriter;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.TypeHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModInfo;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ModWriter1_12_2
extends ModWriter {
    private static final Type EVENT_HANDLER = TypeHelper.fml("common/Mod$EventHandler");
    private static final Type MOD_ANNOTATION = TypeHelper.fml("common/Mod");

    public ModWriter1_12_2(CoreAPI core, MultiVersionModInfo info) {
        super(core, info, CoreAPI.isJava8() ? 52 : 65);
    }

    @Override
    protected void addClassAnnotations(ClassVisitor visitor) {
        this.writeClassAnnotation(visitor, MOD_ANNOTATION, mod -> {
            mod.visit("modid", (Object)this.info.getModID());
            mod.visit("name", (Object)this.info.getName());
            mod.visit("version", (Object)this.info.getVersion());
        });
    }

    @Override
    protected Type getEventMethod(String className) {
        return TypeHelper.method(Type.VOID_TYPE, TypeHelper.fml("common/event/" + className));
    }

    @Override
    protected void mappedEntryPointMethods(Map<String, String[]> redirects, Map<String, Type> types) {
        this.mapEntryPointMethod(redirects, types, "<init>", ASMRef.EMPTY_METHOD, "onConstructed");
        this.mapEntryPointMethod(redirects, types, "preInit", this.getEventMethod("FMLPreInitializationEvent"), "onPreRegistration");
        this.mapEntryPointMethod(redirects, types, "init", this.getEventMethod("FMLInitializationEvent"), "onCommonSetup", "checkClientSetup", "checkDedicatedServerSetup");
        this.mapEntryPointMethod(redirects, types, "postInit", this.getEventMethod("FMLPostInitializationEvent"), "onInterModEnqueue", "onInterModProcess");
        this.mapEntryPointMethod(redirects, types, "loadComplete", this.getEventMethod("FMLLoadCompleteEvent"), "onLoadComplete");
        this.mapEntryPointMethod(redirects, types, "serverAboutToStart", this.getEventMethod("FMLServerAboutToStartEvent"), "onServerAboutToStart");
        this.mapEntryPointMethod(redirects, types, "serverStarting", this.getEventMethod("FMLServerStartingEvent"), "onServerStarting");
        this.mapEntryPointMethod(redirects, types, "serverStarted", this.getEventMethod("FMLServerStartedEvent"), "onServerStarted");
        this.mapEntryPointMethod(redirects, types, "serverStopping", this.getEventMethod("FMLServerStoppingEvent"), "onServerStopping");
        this.mapEntryPointMethod(redirects, types, "serverStopped", this.getEventMethod("FMLServerStoppedEvent"), "onServerStopped");
    }

    @Override
    protected void writeMod(ClassWriter writer, List<Map.Entry<String, byte[]>> classBytes) {
        super.writeMod(writer, classBytes);
        for (Map.Entry entryPoint : this.entryPointMethods.entrySet()) {
            String methodName = (String)entryPoint.getKey();
            if (methodName.equals("<init>")) continue;
            Type eventType = (Type)this.entryPointMethodTypes.get(methodName);
            this.writeMethod((ClassVisitor)writer, visitor -> ASMHelper.getMethod(visitor, 1, methodName, eventType.getArgumentTypes()), method -> {
                this.writeMethodAnnotation((MethodVisitor)method, EVENT_HANDLER, annotation -> {});
                this.addEntryHooks((MethodVisitor)method, false, methodName, false);
            });
        }
    }
}

