/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.v21.tag;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.BaseTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.CompoundTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.TagAPI;
import mods.thecomputerizer.theimpossiblelibrary.forge.v21.tag.CompoundTag1_21;
import mods.thecomputerizer.theimpossiblelibrary.forge.v21.tag.ListTag1_21;
import mods.thecomputerizer.theimpossiblelibrary.forge.v21.tag.PrimitiveTag1_21;
import mods.thecomputerizer.theimpossiblelibrary.forge.v21.tag.StringTag1_21;
import mods.thecomputerizer.theimpossiblelibrary.forge.v21.tag.component.TagComponent1_21;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;

public class Tag1_21
implements TagAPI {
    private final TagComponent1_21 componentDelegate = new TagComponent1_21();

    @Override
    public <T> BaseTagAPI<T> getWrapped(T tag) {
        if (tag instanceof CompoundTag) {
            return new CompoundTag1_21((CompoundTag)tag);
        }
        if (tag instanceof ListTag) {
            return new ListTag1_21((ListTag)tag);
        }
        if (tag instanceof NumericTag) {
            return new PrimitiveTag1_21((NumericTag)tag);
        }
        if (tag instanceof StringTag) {
            return new StringTag1_21((StringTag)tag);
        }
        return this.componentDelegate.getWrapped(tag);
    }

    public CompoundTag1_21 makeCompoundTag() {
        return new CompoundTag1_21(new CompoundTag());
    }

    public ListTag1_21 makeListTag() {
        return new ListTag1_21(new ListTag());
    }

    public PrimitiveTag1_21 makePrimitiveTag(boolean b) {
        return new PrimitiveTag1_21((NumericTag)ByteTag.valueOf((boolean)b));
    }

    public PrimitiveTag1_21 makePrimitiveTag(byte b) {
        return new PrimitiveTag1_21((NumericTag)ByteTag.valueOf((byte)b));
    }

    public PrimitiveTag1_21 makePrimitiveTag(double d) {
        return new PrimitiveTag1_21((NumericTag)DoubleTag.valueOf((double)d));
    }

    public PrimitiveTag1_21 makePrimitiveTag(float f) {
        return new PrimitiveTag1_21((NumericTag)FloatTag.valueOf((float)f));
    }

    public PrimitiveTag1_21 makePrimitiveTag(int i) {
        return new PrimitiveTag1_21((NumericTag)IntTag.valueOf((int)i));
    }

    public PrimitiveTag1_21 makePrimitiveTag(long l) {
        return new PrimitiveTag1_21((NumericTag)LongTag.valueOf((long)l));
    }

    public PrimitiveTag1_21 makePrimitiveTag(short s) {
        return new PrimitiveTag1_21((NumericTag)ShortTag.valueOf((short)s));
    }

    public StringTag1_21 makeStringTag(String value) {
        return new StringTag1_21(StringTag.valueOf((String)value));
    }

    public CompoundTag1_21 readFromFile(File file) throws IOException {
        CompoundTag tag = null;
        try {
            tag = NbtIo.read((Path)file.toPath());
        }
        catch (EOFException ex) {
            TILRef.logWarn("Empty data file {}", file.toPath(), ex.getMessage());
        }
        if (Objects.isNull(tag)) {
            tag = new CompoundTag();
        }
        return new CompoundTag1_21(tag);
    }

    @Override
    public void writeToFile(CompoundTagAPI<?> tag, File file) throws IOException {
        if (!tag.isEmpty()) {
            NbtIo.write((CompoundTag)((CompoundTag)tag.unwrap()), (Path)file.toPath());
        }
    }
}

