/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.v21.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mods.thecomputerizer.theimpossiblelibrary.api.client.font.FontAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.GLAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.VertexWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextAPI;
import mods.thecomputerizer.theimpossiblelibrary.forge.v21.client.render.GL1_21;
import mods.thecomputerizer.theimpossiblelibrary.forge.v21.client.render.VertexWrapper1_21;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL11;

public class Render1_21
extends RenderAPI {
    protected Matrix4fStack modelView;

    public Render1_21() {
        super(new GL1_21());
    }

    @Override
    public void alphaFuncEqual(float alpha) {
        this.assertRenderThread();
        GL11.glAlphaFunc((int)514, (float)alpha);
    }

    @Override
    public void alphaFuncGreater(float alpha) {
        this.assertRenderThread();
        GL11.glAlphaFunc((int)516, (float)alpha);
    }

    @Override
    public void alphaFuncLesser(float alpha) {
        this.assertRenderThread();
        GL11.glAlphaFunc((int)513, (float)alpha);
    }

    void assertRenderThread() {
        RenderSystem.assertOnRenderThreadOrInit();
    }

    @Override
    public Object beginBuffer(Object tesselator, int mode, Object vertexFormat) {
        if (vertexFormat == DefaultVertexFormat.POSITION_COLOR) {
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
        } else if (vertexFormat == DefaultVertexFormat.POSITION_TEX_COLOR) {
            RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        }
        return ((Tesselator)tesselator).begin(this.getBufferMode(mode), (VertexFormat)vertexFormat);
    }

    @Override
    public void bindTexture(ResourceLocationAPI<?> location) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)((ResourceLocation)location.unwrap()));
    }

    @Override
    public void blendTranslucent() {
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }

    @Override
    public void defaultBlendFunc() {
        RenderSystem.defaultBlendFunc();
    }

    @Override
    public void depthMask(boolean mask) {
        RenderSystem.depthMask((boolean)mask);
    }

    @Override
    public void disableAlpha() {
        this.assertRenderThread();
        GL11.glDisable((int)3008);
    }

    @Override
    public void disableBlend() {
        RenderSystem.disableBlend();
    }

    @Override
    public void disableCull() {
        RenderSystem.disableCull();
    }

    @Override
    public void disableLighting() {
        this.assertRenderThread();
        GL11.glDisable((int)2896);
    }

    @Override
    public void disableTexture() {
    }

    @Override
    public void drawCenteredString(FontAPI<?> font, String str, Number x, Number y, int color) {
        this.setColor(ColorHelper.decode(color));
        font.drawWithShadow(this, str, x.floatValue() - (float)font.getStringWidth(str) / 2.0f, y.floatValue(), color);
    }

    @Override
    public void drawString(FontAPI<?> font, String str, Number left, Number top, int color) {
        this.setColor(ColorHelper.decode(color));
        font.draw(this, str, left.intValue(), top.intValue(), color);
    }

    @Override
    public void drawTooltip(FontAPI<?> font, Collection<TextAPI<?>> lines, Number x, Number y, Number width, Number height, Number maxWidth) {
        int iX = x.intValue();
        int iY = y.intValue();
        int iWidth = width.intValue();
        int iHeight = height.intValue();
        int iMaxWidth = maxWidth.intValue();
        Screen curScreen = Minecraft.getInstance().screen;
        if (Objects.nonNull(curScreen)) {
            List unwrapped = font.unwrapTooltipComponents(lines);
            GuiGraphics graphics = this.getGraphics();
            if (Objects.nonNull(graphics)) {
                graphics.renderComponentTooltip((Font)font.unwrap(), unwrapped, iX, iY);
            }
        } else {
            font.renderToolTip(this, lines, iX, iY, iWidth, iHeight, iMaxWidth);
        }
    }

    @Override
    public void enableAlpha() {
    }

    @Override
    public void enableBlend() {
        RenderSystem.enableBlend();
    }

    @Override
    public void enableCull() {
        RenderSystem.enableCull();
    }

    @Override
    public void enableLighting() {
        this.assertRenderThread();
        GL11.glEnable((int)2896);
    }

    @Override
    public void enableTexture() {
    }

    @Override
    public void endBuffer() {
    }

    @Override
    public void endVertex(Object buffer) {
    }

    @Override
    public <B> B getBufferBuilder() {
        return null;
    }

    @Override
    public VertexWrapper getBufferBuilderPC(int mode, int vertices) {
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return new VertexWrapper1_21(this.getBufferMode(mode), DefaultVertexFormat.POSITION_COLOR, vertices, 3, 4);
    }

    @Override
    public VertexWrapper getBufferBuilderPTC(int mode, int vertices) {
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return new VertexWrapper1_21(this.getBufferMode(mode), DefaultVertexFormat.POSITION_TEX_COLOR, vertices, 3, 2, 4);
    }

    protected VertexFormat.Mode getBufferMode(int mode) {
        return switch (mode) {
            case 6913 -> VertexFormat.Mode.LINES;
            case 2, 3 -> VertexFormat.Mode.LINE_STRIP;
            case 4 -> VertexFormat.Mode.TRIANGLES;
            case 6 -> VertexFormat.Mode.TRIANGLE_FAN;
            case 5 -> VertexFormat.Mode.TRIANGLE_STRIP;
            default -> VertexFormat.Mode.QUADS;
        };
    }

    @Override
    public double getDirectMouseX() {
        return Minecraft.getInstance().mouseHandler.xpos();
    }

    @Override
    public double getDirectMouseY() {
        return Minecraft.getInstance().mouseHandler.ypos();
    }

    public Font getFont() {
        return (Font)this.unwrapFont();
    }

    @Override
    public GLAPI getGLAPI() {
        return this.gl;
    }

    @Nullable
    public GuiGraphics getGraphics() {
        return this.matrix instanceof GuiGraphics ? (GuiGraphics)this.matrix : null;
    }

    public PoseStack getMatrix() {
        return this.matrix instanceof GuiGraphics ? ((GuiGraphics)this.matrix).pose() : (PoseStack)this.unwrapMatrix();
    }

    @Override
    public RenderAPI init(Object context) {
        this.setMatrix(context);
        return this;
    }

    @Override
    public void modelView() {
        if (Objects.nonNull(this.modelView)) {
            this.modelView.popMatrix();
            RenderSystem.applyModelViewMatrix();
            this.modelView = null;
        } else {
            this.modelView = RenderSystem.getModelViewStack();
            this.modelView.pushMatrix().mul((Matrix4fc)RenderSystem.getProjectionMatrix());
            RenderSystem.applyModelViewMatrix();
        }
    }

    @Override
    public void popMatrix() {
        this.getMatrix().popPose();
    }

    @Override
    public void pushMatrix() {
        this.getMatrix().pushPose();
    }

    @Override
    public Object renderSourceImmediate() {
        return null;
    }

    @Override
    public void resetTextureMatrix() {
        RenderSystem.resetTextureMatrix();
    }

    @Override
    public void rotate(float angle, float x, float y, float z) {
        this.assertRenderThread();
        GL11.glRotatef((float)angle, (float)x, (float)y, (float)z);
    }

    @Override
    public void scale(float x, float y, float z) {
        PoseStack stack = this.getMatrix();
        if (Objects.isNull(stack)) {
            TILRef.logError("Tried to scale PoseStack without setting it first", new Object[0]);
        } else {
            stack.scale(x, y, z);
        }
    }

    @Override
    public void setColor(float r, float g, float b, float a) {
        GuiGraphics graphics = this.getGraphics();
        if (Objects.nonNull(graphics)) {
            graphics.setColor(r, g, b, a);
        } else {
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        }
    }

    @Override
    public void setPosColorShader() {
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
    }

    @Override
    public void translate(double x, double y, double z) {
        PoseStack stack = this.getMatrix();
        if (Objects.isNull(stack)) {
            TILRef.logError("Tried to translate PoseStack without setting it first", new Object[0]);
        } else {
            stack.translate(x, y, z);
        }
    }

    @Override
    public void translate(float x, float y, float z) {
        PoseStack stack = this.getMatrix();
        if (Objects.isNull(stack)) {
            TILRef.logError("Tried to translate PoseStack without setting it first", new Object[0]);
        } else {
            stack.translate(x, y, z);
        }
    }

    @Override
    public <B> B vertexWithMatrix(B buffer, Object matrix, float x, float y, float z) {
        ((BufferBuilder)buffer).addVertex((Matrix4f)matrix, x, y, z);
        return buffer;
    }

    @Override
    public <B> B vertexColor(B buffer, float red, float green, float blue, float alpha) {
        ((BufferBuilder)buffer).setColor(red, green, blue, alpha);
        return buffer;
    }
}

