/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.v21.client.render;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.GLAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.util.MathHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class GL1_21
implements GLAPI {
    protected float r = 1.0f;
    protected float g = 1.0f;
    protected float b = 1.0f;
    protected float a = 1.0f;
    protected VertexFormat workingFormat;
    protected BufferBuilder workingBuffer;
    protected PoseStack.Pose workingPose;
    private double scaleX = 1.0;
    private double scaleY = 1.0;

    @Override
    public void directBegin(int modeVal) {
        Tesselator tesselator = RenderSystem.renderThreadTesselator();
        this.workingFormat = DefaultVertexFormat.POSITION_COLOR_NORMAL;
        this.workingBuffer = tesselator.begin(VertexFormat.Mode.LINES, this.workingFormat);
        this.setWorkingColor(RenderSystem.getShaderColor());
        Window window = Minecraft.getInstance().getWindow();
        double width = window.getWidth();
        double height = window.getHeight();
        double widthFactor = height > width ? width / height : 1.0;
        double heightFactor = width > height ? height / width : 1.0;
        this.scaleX = 1.0 + 1.0 / width * 16.0 * widthFactor;
        this.scaleY = 1.0 + 1.0 / height * 16.0 * heightFactor;
    }

    @Override
    public void directEnd() {
        if (Objects.isNull(this.workingBuffer)) {
            TILRef.logError("Cannot directly end buffer before calling directBegin!", new Object[0]);
        } else {
            RenderSystem.disableCull();
            this.endWithShader(this.workingFormat);
            RenderSystem.enableCull();
            this.workingBuffer = null;
            this.r = 1.0f;
            this.g = 1.0f;
            this.b = 1.0f;
            this.a = 1.0f;
        }
    }

    @Override
    public void directVertexD(double x, double y, double z) {
        if (Objects.isNull(this.workingBuffer)) {
            TILRef.logError("Cannot directly add vertex (3D) to buffer before calling directBegin!", new Object[0]);
        } else {
            this.normalizedVertex(x, y, z, this.r, this.g, this.b, this.a, x, y, z);
        }
    }

    @Override
    public void directVertexD(double x, double y) {
        if (Objects.isNull(this.workingBuffer)) {
            TILRef.logError("Cannot directly add vertex (2D) to buffer before calling directBegin!", new Object[0]);
        } else {
            this.normalizedVertex(x, y, 0.0, this.r, this.g, this.b, this.a, x, y, 0.0);
        }
    }

    @Override
    public void directVertexF(float x, float y, float z) {
        if (Objects.isNull(this.workingBuffer)) {
            TILRef.logError("Cannot directly add vertex (3F) to buffer before calling directBegin!", new Object[0]);
        } else {
            this.normalizedVertex(x, y, z, this.r, this.g, this.b, this.a, x, y, z);
        }
    }

    @Override
    public void directVertexF(float x, float y) {
        if (Objects.isNull(this.workingBuffer)) {
            TILRef.logError("Cannot directly add vertex (2F) to buffer before calling directBegin!", new Object[0]);
        } else {
            this.normalizedVertex(x, y, 0.0, this.r, this.g, this.b, this.a, x, y, 0.0);
        }
    }

    @Override
    public void disable(int cap) {
        GL11.glDisable((int)cap);
    }

    @Override
    public void enable(int cap) {
        GL11.glEnable((int)cap);
    }

    void endWithShader(VertexFormat format) {
        if (format == DefaultVertexFormat.POSITION_COLOR) {
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
        } else if (format == DefaultVertexFormat.POSITION_TEX_COLOR) {
            RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        } else if (format == DefaultVertexFormat.POSITION_COLOR_NORMAL) {
            RenderSystem.setShader(GameRenderer::getRendertypeLinesShader);
        }
        BufferUploader.drawWithShader((MeshData)this.workingBuffer.buildOrThrow());
        RenderSystem.setShader(() -> null);
    }

    @Override
    public int lineStrip() {
        return 3;
    }

    @Override
    public int lines() {
        return 1;
    }

    protected VertexConsumer normal(VertexConsumer consumer, float x, float y, float z) {
        return Objects.nonNull(this.workingPose) ? consumer.setNormal(this.workingPose, x, y, z) : consumer.setNormal(x, y, z);
    }

    @Override
    public void normalizedVertex(double x, double y, double z, float r, float g, float b, float a, double nextX, double nextY, double nextZ) {
        if (Objects.isNull(this.workingBuffer)) {
            TILRef.logError("Cannot add normalized vertex to buffer before calling directBegin!", new Object[0]);
        }
        boolean same = x == nextX && y == nextY && z == nextZ;
        double nX = same ? 1.0 : (nextX *= this.scaleX) - (x *= this.scaleX);
        double nY = same ? 1.0 : (nextY *= this.scaleY) - (y *= this.scaleY);
        double nZ = same ? 1.0 : nextZ - z;
        double dist = MathHelper.distance(nX, nY, nZ);
        this.normal(this.vertex(x, y, z).setColor(r, g, b, a), (float)(nX /= dist), (float)(nY /= dist), (float)(nZ /= dist));
        this.normal(this.vertex(nextX, nextY, nextZ).setColor(r, g, b, a), (float)nX, (float)nY, (float)nZ);
    }

    @Override
    public int quads() {
        return 7;
    }

    @Override
    public void scissor(int left, int bottom, int width, int height) {
        GL20.glScissor((int)left, (int)bottom, (int)width, (int)height);
    }

    @Override
    public int scissorTest() {
        return 3089;
    }

    @Override
    public void setLineWidth(float width) {
        RenderSystem.lineWidth((float)width);
    }

    private void setWorkingColor(float ... workingColor) {
        this.r = workingColor[0];
        this.g = workingColor[1];
        this.b = workingColor[2];
        this.a = workingColor[3];
    }

    @Override
    public void setWorkingMatrix(Object matrix) {
        if (matrix instanceof GuiGraphics) {
            this.workingPose = ((GuiGraphics)matrix).pose().last();
        } else if (matrix instanceof PoseStack) {
            this.workingPose = ((PoseStack)matrix).last();
        } else if (matrix instanceof PoseStack.Pose) {
            this.workingPose = (PoseStack.Pose)matrix;
        } else {
            if (Objects.nonNull(matrix)) {
                TILRef.logError("Tried to set working Pose for GL1_21 to a non GuiGraphics, PoseStack, or Pose {}", matrix);
            }
            this.workingPose = null;
        }
    }

    @Override
    public int triangles() {
        return 4;
    }

    @Override
    public int triangleFan() {
        return 6;
    }

    protected VertexConsumer vertex(double x, double y, double z) {
        return Objects.nonNull(this.workingPose) ? this.workingBuffer.addVertex(this.workingPose.pose(), (float)x, (float)y, (float)z) : this.workingBuffer.addVertex((float)x, (float)y, (float)z);
    }
}

