/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.v20.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mods.thecomputerizer.theimpossiblelibrary.api.client.font.FontAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.GLAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.VertexWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextAPI;
import mods.thecomputerizer.theimpossiblelibrary.forge.v20.client.render.GL1_20;
import mods.thecomputerizer.theimpossiblelibrary.forge.v20.client.render.VertexWrapper1_20;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class Render1_20
extends RenderAPI {
    protected PoseStack modelView;

    protected Render1_20(GL1_20 gl) {
        super(gl);
    }

    public Render1_20() {
        super(new GL1_20());
    }

    @Override
    public void alphaFuncEqual(float alpha) {
        this.assertRenderThread();
        GL11.glAlphaFunc((int)514, (float)alpha);
    }

    @Override
    public void alphaFuncGreater(float alpha) {
        this.assertRenderThread();
        GL11.glAlphaFunc((int)516, (float)alpha);
    }

    @Override
    public void alphaFuncLesser(float alpha) {
        this.assertRenderThread();
        GL11.glAlphaFunc((int)513, (float)alpha);
    }

    void assertRenderThread() {
        RenderSystem.assertOnRenderThreadOrInit();
    }

    @Override
    public Object beginBuffer(Object buffer, int mode, Object vertexFormat) {
        if (vertexFormat == DefaultVertexFormat.f_85815_) {
            RenderSystem.setShader(GameRenderer::m_172811_);
        } else if (vertexFormat == DefaultVertexFormat.f_85819_) {
            RenderSystem.setShader(GameRenderer::m_172820_);
        }
        ((BufferBuilder)buffer).m_166779_(this.getBufferMode(mode), (VertexFormat)vertexFormat);
        return buffer;
    }

    @Override
    public void bindTexture(ResourceLocationAPI<?> location) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)((ResourceLocation)location.unwrap()));
    }

    @Override
    public void blendTranslucent() {
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }

    @Override
    public void defaultBlendFunc() {
        RenderSystem.defaultBlendFunc();
    }

    @Override
    public void depthMask(boolean mask) {
        RenderSystem.depthMask((boolean)mask);
    }

    @Override
    public void disableAlpha() {
        this.assertRenderThread();
        GL11.glDisable((int)3008);
    }

    @Override
    public void disableBlend() {
        RenderSystem.disableBlend();
    }

    @Override
    public void disableCull() {
        RenderSystem.disableCull();
    }

    @Override
    public void disableLighting() {
        this.assertRenderThread();
        GL11.glDisable((int)2896);
    }

    @Override
    public void disableTexture() {
    }

    @Override
    public void drawCenteredString(FontAPI<?> font, String str, Number x, Number y, int color) {
        this.setColor(ColorHelper.decode(color));
        font.drawWithShadow(this, str, x.floatValue() - (float)font.getStringWidth(str) / 2.0f, y.floatValue(), color);
    }

    @Override
    public void drawString(FontAPI<?> font, String str, Number left, Number top, int color) {
        this.setColor(ColorHelper.decode(color));
        font.draw(this, str, left.intValue(), top.intValue(), color);
    }

    @Override
    public void drawTooltip(FontAPI<?> font, Collection<TextAPI<?>> lines, Number x, Number y, Number width, Number height, Number maxWidth) {
        int iX = x.intValue();
        int iY = y.intValue();
        int iWidth = width.intValue();
        int iHeight = height.intValue();
        int iMaxWidth = maxWidth.intValue();
        Screen curScreen = Minecraft.m_91087_().f_91080_;
        if (Objects.nonNull(curScreen)) {
            List unwrapped = font.unwrapTooltipComponents(lines);
            GuiGraphics graphics = this.getGraphics();
            if (Objects.nonNull(graphics)) {
                graphics.m_280666_((Font)font.unwrap(), unwrapped, iX, iY);
            }
        } else {
            font.renderToolTip(this, lines, iX, iY, iWidth, iHeight, iMaxWidth);
        }
    }

    @Override
    public void enableAlpha() {
    }

    @Override
    public void enableBlend() {
        RenderSystem.enableBlend();
    }

    @Override
    public void enableCull() {
        RenderSystem.enableCull();
    }

    @Override
    public void enableLighting() {
        this.assertRenderThread();
        GL11.glEnable((int)2896);
    }

    @Override
    public void enableTexture() {
    }

    @Override
    public void endBuffer() {
        Tesselator.m_85913_().m_85914_();
    }

    @Override
    public void endVertex(Object buffer) {
        ((BufferBuilder)buffer).m_5752_();
    }

    @Override
    public <B> B getBufferBuilder() {
        return (B)Tesselator.m_85913_().m_85915_();
    }

    @Override
    public VertexWrapper getBufferBuilderPC(int mode, int vertices) {
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return new VertexWrapper1_20(this.getBufferMode(mode), DefaultVertexFormat.f_85815_, vertices, 3, 4);
    }

    @Override
    public VertexWrapper getBufferBuilderPTC(int mode, int vertices) {
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return new VertexWrapper1_20(this.getBufferMode(mode), DefaultVertexFormat.f_85819_, vertices, 3, 2, 4);
    }

    protected VertexFormat.Mode getBufferMode(int mode) {
        return switch (mode) {
            case 6913 -> VertexFormat.Mode.LINES;
            case 2, 3 -> VertexFormat.Mode.LINE_STRIP;
            case 4 -> VertexFormat.Mode.TRIANGLES;
            case 6 -> VertexFormat.Mode.TRIANGLE_FAN;
            case 5 -> VertexFormat.Mode.TRIANGLE_STRIP;
            default -> VertexFormat.Mode.QUADS;
        };
    }

    @Override
    public double getDirectMouseX() {
        return Minecraft.m_91087_().f_91067_.m_91589_();
    }

    @Override
    public double getDirectMouseY() {
        return Minecraft.m_91087_().f_91067_.m_91594_();
    }

    public Font getFont() {
        return (Font)this.unwrapFont();
    }

    @Override
    public GLAPI getGLAPI() {
        return this.gl;
    }

    @Nullable
    public GuiGraphics getGraphics() {
        return this.matrix instanceof GuiGraphics ? (GuiGraphics)this.matrix : null;
    }

    public PoseStack getMatrix() {
        return this.matrix instanceof GuiGraphics ? ((GuiGraphics)this.matrix).m_280168_() : (PoseStack)this.unwrapMatrix();
    }

    @Override
    public RenderAPI init(Object context) {
        this.setMatrix(context);
        return this;
    }

    @Override
    public void modelView() {
        if (Objects.nonNull(this.modelView)) {
            this.modelView.m_85849_();
            RenderSystem.applyModelViewMatrix();
            this.modelView = null;
        } else {
            this.modelView = RenderSystem.getModelViewStack();
            this.modelView.m_85836_();
            this.modelView.m_252931_(this.getMatrix().m_85850_().m_252922_());
            RenderSystem.applyModelViewMatrix();
        }
    }

    @Override
    public void popMatrix() {
        this.getMatrix().m_85849_();
    }

    @Override
    public void pushMatrix() {
        this.getMatrix().m_85836_();
    }

    @Override
    public Object renderSourceImmediate() {
        return MultiBufferSource.m_109898_((BufferBuilder)((BufferBuilder)this.getBufferBuilder()));
    }

    @Override
    public void resetTextureMatrix() {
        RenderSystem.resetTextureMatrix();
    }

    @Override
    public void rotate(float angle, float x, float y, float z) {
        this.assertRenderThread();
        GL11.glRotatef((float)angle, (float)x, (float)y, (float)z);
    }

    @Override
    public void scale(float x, float y, float z) {
        PoseStack stack = this.getMatrix();
        if (Objects.isNull(stack)) {
            TILRef.logError("Tried to scale PoseStack without setting it first", new Object[0]);
        } else {
            stack.m_85841_(x, y, z);
        }
    }

    @Override
    public void setColor(float r, float g, float b, float a) {
        GuiGraphics graphics = this.getGraphics();
        if (Objects.nonNull(graphics)) {
            graphics.m_280246_(r, g, b, a);
        } else {
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        }
    }

    @Override
    public void setPosColorShader() {
        RenderSystem.setShader(GameRenderer::m_172811_);
    }

    @Override
    public void translate(double x, double y, double z) {
        PoseStack stack = this.getMatrix();
        if (Objects.isNull(stack)) {
            TILRef.logError("Tried to translate PoseStack without setting it first", new Object[0]);
        } else {
            stack.m_85837_(x, y, z);
        }
    }

    @Override
    public void translate(float x, float y, float z) {
        PoseStack stack = this.getMatrix();
        if (Objects.isNull(stack)) {
            TILRef.logError("Tried to translate PoseStack without setting it first", new Object[0]);
        } else {
            stack.m_252880_(x, y, z);
        }
    }

    @Override
    public <B> B vertexWithMatrix(B buffer, Object matrix, float x, float y, float z) {
        ((BufferBuilder)buffer).m_252986_((Matrix4f)matrix, x, y, z);
        return buffer;
    }

    @Override
    public <B> B vertexColor(B buffer, float red, float green, float blue, float alpha) {
        ((BufferBuilder)buffer).m_85950_(red, green, blue, alpha);
        return buffer;
    }
}

