/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.v18.m2.server;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.server.CommandAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.server.CommandSenderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.server.MinecraftServerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.server.ServerHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.WrapperHelper;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;

@ParametersAreNonnullByDefault
public class WrappedCommand1_18_2 {
    public static int execute(CommandContext<CommandSourceStack> ctx, CommandAPI wrapped) throws CommandRuntimeException {
        wrapped.prepareExceptionInfo();
        String exKey = wrapped.getExceptionKey();
        exKey = Objects.nonNull(exKey) ? exKey : "";
        Object[] exArgs = wrapped.getExceptionArgs();
        try {
            String[] args = WrappedCommand1_18_2.getArgStack(ctx);
            wrapped.execute(ctx, WrappedCommand1_18_2.rebuildInput(args), args[args.length - 1]);
            return 1;
        }
        catch (Exception ex) {
            TILRef.logError("Caught exception for command {}! Rethrowing as CommandException", wrapped.getRootName(), ex);
            throw new CommandRuntimeException((Component)TextHelper.getTranslated(exKey, exArgs).getAsComponent());
        }
    }

    private static ArgumentBuilder<CommandSourceStack, ?> getArg(CommandAPI command) {
        ArgumentBuilder<CommandSourceStack, ?> arg = WrappedCommand1_18_2.getBuilder(command);
        for (CommandAPI subcmd : command.getSubCommands()) {
            arg.then(WrappedCommand1_18_2.getArg(subcmd));
        }
        if (command.isExecutionNode()) {
            arg.executes(ctx -> WrappedCommand1_18_2.execute((CommandContext<CommandSourceStack>)ctx, command));
        }
        return arg;
    }

    private static String[] getArgStack(CommandContext<?> ctx) {
        String input = ctx.getInput();
        if (!input.contains(" ")) {
            return new String[0];
        }
        return input.substring(input.indexOf(" ") + 1).split(" ");
    }

    private static ArgumentBuilder<CommandSourceStack, ?> getBuilder(CommandAPI command) {
        String name = command.getName();
        return switch (command.getType()) {
            case CommandAPI.ArgType.BOOLEAN -> Commands.m_82129_((String)name, (ArgumentType)BoolArgumentType.bool());
            case CommandAPI.ArgType.DOUBLE -> Commands.m_82129_((String)name, (ArgumentType)DoubleArgumentType.doubleArg());
            case CommandAPI.ArgType.ENTITY -> Commands.m_82129_((String)name, (ArgumentType)EntityArgument.m_91449_());
            case CommandAPI.ArgType.FLOAT -> Commands.m_82129_((String)name, (ArgumentType)FloatArgumentType.floatArg());
            case CommandAPI.ArgType.INTEGER -> Commands.m_82129_((String)name, (ArgumentType)IntegerArgumentType.integer());
            case CommandAPI.ArgType.LITERAL -> Commands.m_82127_((String)name);
            case CommandAPI.ArgType.LONG -> Commands.m_82129_((String)name, (ArgumentType)LongArgumentType.longArg());
            case CommandAPI.ArgType.PLAYER -> Commands.m_82129_((String)name, (ArgumentType)EntityArgument.m_91466_());
            default -> Commands.m_82129_((String)name, (ArgumentType)new CustomSuggester(command));
        };
    }

    private static String rebuildInput(String ... args) {
        StringJoiner joiner = new StringJoiner(" ");
        for (int i = 0; i < args.length - 1; ++i) {
            joiner.add(args[i]);
        }
        return joiner.toString();
    }

    public static void register(Object dispatcherObj, CommandAPI wrapped) {
        CommandDispatcher dispatcher = (CommandDispatcher)dispatcherObj;
        LiteralArgumentBuilder root = Commands.m_82127_((String)wrapped.getName());
        for (CommandAPI subcmd : wrapped.getSubCommands()) {
            root.then(WrappedCommand1_18_2.getArg(subcmd));
        }
        if (wrapped.isExecutionNode()) {
            root.executes(ctx -> WrappedCommand1_18_2.execute((CommandContext<CommandSourceStack>)ctx, wrapped));
        }
        dispatcher.register(root);
    }

    record CustomSuggester(CommandAPI command) implements ArgumentType<String>
    {
        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> ctx, SuggestionsBuilder builder) {
            MinecraftServerAPI<?> server = ServerHelper.getAPI();
            CommandSenderAPI sender = WrapperHelper.wrapCommandSender(ctx);
            return SharedSuggestionProvider.m_82970_(this.command.getTabCompletions(server, sender, builder.getInput(), builder.getRemaining()), (SuggestionsBuilder)builder);
        }

        public String parse(StringReader reader) {
            return reader.readUnquotedString();
        }
    }
}

