/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.core.loader;

import java.lang.reflect.Constructor;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.ForgeCoreLoader;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.burningwave.core.assembler.StaticComponentContainer;

public abstract class TILLanguageLoader {
    private static final String MOD_CONTAINER = "net.minecraftforge.fml.javafmlmod.FMLModContainer";
    static boolean loadedNewCore;
    protected final CoreAPI core;
    protected final String modClass;
    protected final String modid;
    protected final ModFileScanData scan;

    protected TILLanguageLoader(CoreAPI core, String modClass, String modid, ModFileScanData scan) {
        this.core = core;
        this.modClass = modClass;
        this.modid = modid;
        this.scan = scan;
    }

    private <T> T getInstance(Class<?> container, IModInfo info, ClassLoader classLoader, ModFileScanData scanResults, Object ... extras) {
        try {
            boolean java8 = ForgeCoreLoader.isJava8();
            Constructor<?> init = java8 ? container.getConstructor(IModInfo.class, String.class, ClassLoader.class, ModFileScanData.class) : container.getConstructor(IModInfo.class, String.class, ModFileScanData.class, extras[0].getClass());
            Object instance = java8 ? init.newInstance(info, this.modClass, classLoader, scanResults) : init.newInstance(info, this.modClass, scanResults, extras[0]);
            TILRef.logInfo("Successfully initialized mod container for {}", this.modClass);
            return (T)instance;
        }
        catch (Throwable t) {
            TILRef.logError("Failed to initialize {} (modClass {})", container, this.modClass, t);
            return null;
        }
    }

    protected <T> T loadModInner(IModInfo info, ClassLoader classLoader, ModFileScanData scanResults, Object ... extras) {
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> container = Class.forName(MOD_CONTAINER, true, contextLoader);
            String coreName = this.core.getClass().getName();
            StaticComponentContainer.Methods.invoke((Object)this.scan, "defineClasses", classLoader);
            if (!loadedNewCore) {
                this.setCoreAPI(Class.forName(coreName, true, classLoader));
            }
            if (extras.length > 0) {
                ForgeCoreLoader.verifyModule(this.modClass, info, extras[0]);
            }
            return this.getInstance(container, info, classLoader, scanResults, extras);
        }
        catch (Throwable t) {
            String msg = "Failed to load net.minecraftforge.fml.javafmlmod.FMLModContainer for multiversion mod!";
            TILRef.logError(msg, t);
            throw new RuntimeException(msg, t);
        }
    }

    protected void setCoreAPI(Class<?> implClass) {
        try {
            implClass.newInstance();
            loadedNewCore = true;
        }
        catch (Throwable t) {
            TILRef.logError("Failed to set CoreAPI instance {}", implClass, t);
        }
    }

    @Generated
    public String getModid() {
        return this.modid;
    }
}

