/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.core;

import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.ForgeCoreLoader;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.loader.ForgeModLoading;
import net.minecraftforge.forgespi.language.ILifecycleEvent;
import net.minecraftforge.forgespi.language.IModLanguageProvider;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.objectweb.asm.Type;

public class TILLanguageProvider
implements IModLanguageProvider {
    final Object core;

    public TILLanguageProvider() {
        TILRef.logInfo("Initializing multiversion language provider (Forge edition)", new Object[0]);
        ClassLoader pluginLoader = ForgeCoreLoader.isJava8() ? this.getClass().getClassLoader() : ForgeCoreLoader.layerClassLoader("PLUGIN");
        this.core = ForgeCoreLoader.initCoreAPI(pluginLoader);
        TILRef.logInfo("Retrieved CoreAPI instance {} for multiversion language provider", this.core);
    }

    public <R extends ILifecycleEvent<R>> void consumeLifecycleEvent(Supplier<R> ignored) {
    }

    public Consumer<ModFileScanData> getFileVisitor() {
        boolean pathBased = ForgeModLoading.isPathBased();
        Function<ModFileScanData.AnnotationData, Type> typeMapper = data -> (Type)StaticComponentContainer.Methods.invoke(data, pathBased ? "getAnnotationType" : "annotationType", new Object[0]);
        Function<ModFileScanData.AnnotationData, Type> classTypeMapper = data -> (Type)StaticComponentContainer.Methods.invoke(data, pathBased ? "getClassType" : "clazz", new Object[0]);
        Function<ModFileScanData.AnnotationData, Map> dataMapper = data -> (Map)StaticComponentContainer.Methods.invoke(data, pathBased ? "getAnnotationData" : "annotationData", new Object[0]);
        Type modAnnotation = Type.getType((String)"Lnet/minecraftforge/fml/common/Mod;");
        Class<?> loaderClass = this.getLanguageLoaderClass();
        Function<IModLanguageProvider.IModLanguageLoader, String> loadModIDMapper = loader -> (String)StaticComponentContainer.Methods.invoke(loader, "getModid", new Object[0]);
        return Objects.isNull(loaderClass) ? scan -> {} : scan -> scan.addLanguageLoader(scan.getAnnotations().stream().filter(ad -> ((Type)typeMapper.apply((ModFileScanData.AnnotationData)ad)).equals((Object)modAnnotation)).map(ad -> {
            String className = ((Type)classTypeMapper.apply((ModFileScanData.AnnotationData)ad)).getClassName();
            String value = String.valueOf(((Map)dataMapper.apply((ModFileScanData.AnnotationData)ad)).get("value"));
            TILRef.logInfo("Found @Mod class {} with id {}", className, value);
            return (IModLanguageProvider.IModLanguageLoader)StaticComponentContainer.Constructors.newInstanceOf(loaderClass, this.core, className, value, scan);
        }).collect(Collectors.toMap(loadModIDMapper, Function.identity(), (a, b) -> a)));
    }

    String getFixedClassName(String className) {
        return className.contains("1_19") || className.contains("1_20") || className.contains("1_21") ? className.substring(0, className.length() - 2) : className;
    }

    String getFixedPkg(String pkg) {
        return pkg.contains("v19") || pkg.contains("v20") || pkg.contains("v21") ? pkg.substring(0, pkg.length() - 3) : pkg;
    }

    Class<?> getLanguageLoaderClass() {
        Object modLoader = StaticComponentContainer.Methods.invoke(this.core, "getModLoader", new Object[0]);
        String pkg = "mods.thecomputerizer.theimpossiblelibrary";
        pkg = (String)StaticComponentContainer.Methods.invoke(modLoader, "getPackageName", pkg);
        Object version = StaticComponentContainer.Methods.invoke(this.core, "getVersion", new Object[0]);
        pkg = this.getFixedPkg((String)StaticComponentContainer.Methods.invoke(version, "getPackageName", pkg));
        String className = this.getFixedClassName(("TILLanguageLoader" + version).replace('.', '_'));
        className = pkg + ".core.loader." + className;
        try {
            return Class.forName(className, true, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            TILRef.logError("Failed to get language loader class {}", className, ex);
            return null;
        }
    }

    public String name() {
        return "multiversionprovider";
    }

    static {
        try {
            ClassLoader plugin = TILLanguageProvider.class.getClassLoader();
            ForgeCoreLoader.resyncModules(plugin, "PLUGIN", ForgeCoreLoader.bootLoader());
        }
        catch (Throwable t) {
            TILRef.logError("Failed to resync modules to BOOT layer", t);
        }
    }
}

