/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.core;

import cpw.mods.modlauncher.Launcher;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.security.CodeSigner;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.annotation.Nullable;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.ForgeCoreLoader;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.loader.ForgeModLoading;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import org.apache.commons.lang3.tuple.Pair;
import org.burningwave.core.assembler.StaticComponentContainer;

public class MultiVersionModLocator
implements IModLocator {
    private Map<IModFile, FileSystem> fileSystems;
    boolean failed;

    public MultiVersionModLocator() {
        TILRef.logInfo("Core Forge Locator plugin loaded on {}", this.getClass().getClassLoader());
        this.setLoadingVersion(ForgeCoreLoader.initCoreAPI(Launcher.class.getClassLoader()));
    }

    void setLoadingVersion(@Nullable Object coreInstance) {
        if (Objects.isNull(coreInstance)) {
            TILRef.logError("Failed to set Forge mod loading version with null CoreAPI instance!", new Object[0]);
            this.failed = true;
            return;
        }
        ClassHelper.checkBurningWaveInit();
        String version = String.valueOf(StaticComponentContainer.Methods.invoke(coreInstance, "gameVersion", new Object[0]));
        String checkedVersion = version.substring(2).replace('.', '_');
        ForgeModLoading.setFileVersion(this.getClass(), checkedVersion, version);
        TILRef.logInfo("Successfully set Forge mod loading version ({},{})", checkedVersion, version);
    }

    FileSystem fileSystemFor(IModFile file) {
        try {
            return FileSystems.newFileSystem(file.getFilePath(), file.getClass().getClassLoader());
        }
        catch (IOException ex) {
            TILRef.logError("Could not create file system for {}", file.getFilePath(), ex);
            return null;
        }
    }

    public Optional<Manifest> findManifest(Path path) {
        return (Optional)this.findManifestAndSigners(path).getKey();
    }

    public Pair<Optional<Manifest>, Optional<CodeSigner[]>> findManifestAndSigners(Path path) {
        Pair pair;
        JarFile jar = new JarFile(path.toFile());
        try {
            Manifest manifest = jar.getManifest();
            Optional<Object> optionalManifest = Objects.nonNull(manifest) ? Optional.of(manifest) : Optional.empty();
            pair = Pair.of(optionalManifest, Optional.empty());
        }
        catch (Throwable throwable) {
            try {
                try {
                    jar.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable t) {
                TILRef.logError("Failed to find manifest & signers for {}", path, t);
                return Pair.of(Optional.empty(), Optional.empty());
            }
        }
        jar.close();
        return pair;
    }

    public Path findPath(IModFile modFile, String ... paths) {
        if (paths.length < 1) {
            throw new IllegalArgumentException("Missing path");
        }
        ForgeModLoading.queryCoreMods(paths);
        return this.fileSystems.get(modFile).getPath("", paths);
    }

    public void initArguments(Map<String, ?> arguments) {
        if (this.failed) {
            TILRef.logWarn("Not initializing mod loading for MultiVersionModLocator that failed to load", new Object[0]);
            return;
        }
        TILRef.logInfo("Initializing Forge mod loading with args {}", arguments);
        ForgeModLoading.initModLoading(this.getClass().getClassLoader(), this);
    }

    public boolean isValid(IModFile file) {
        return !this.failed;
    }

    public String name() {
        return "multiversionloader";
    }

    public void scanFile(IModFile file, Consumer<Path> consumer) {
    }

    public List<IModFile> scanMods() {
        if (this.failed) {
            TILRef.logWarn("Not scanning for mods with MultiVersionModLocator that failed to load", new Object[0]);
            return Collections.emptyList();
        }
        TILRef.logInfo("Scanning for mods", new Object[0]);
        this.fileSystems = Collections.emptyMap();
        try {
            List<IModFile> files = ForgeModLoading.scanMods();
            if (!files.isEmpty() && ForgeModLoading.isPathBased()) {
                this.fileSystems = new HashMap<IModFile, FileSystem>();
                for (IModFile file : files) {
                    FileSystem fs = this.fileSystemFor(file);
                    if (!Objects.nonNull(fs)) continue;
                    this.fileSystems.put(file, fs);
                }
            }
            TILRef.logInfo("Returing scanned mods {}", files);
            return files;
        }
        catch (Throwable t) {
            TILRef.logError("Failed to scan mods", t);
            throw t;
        }
    }

    @Generated
    public Map<IModFile, FileSystem> getFileSystems() {
        return this.fileSystems;
    }

    @Generated
    public boolean isFailed() {
        return this.failed;
    }

    static {
        ForgeCoreLoader.fixFirstEntryPoint();
        Object instance = ForgeCoreLoader.initCoreAPI(MultiVersionModLocator.class.getClassLoader());
        if (Objects.isNull(instance)) {
            throw new RuntimeException("Failed to retrieve CoreAPI instance for MultiVersionModLocator");
        }
    }
}

