/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.core;

import cpw.mods.modlauncher.ArgumentHandler;
import cpw.mods.modlauncher.Environment;
import cpw.mods.modlauncher.Launcher;
import io.github.toolfactory.jvm.function.catalog.ConsulterSupplyFunction;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import javax.annotation.Nullable;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.Fields;

public class ForgeCoreLoader {
    private static final String API_PKG = "mods.thecomputerizer.theimpossiblelibrary.api";
    private static final String FORGE_PKG = "mods.thecomputerizer.theimpossiblelibrary.forge";
    private static final String APICORE = "mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI";
    private static final Logger LOGGER = LogManager.getLogger((String)"TIL ForgeCoreLoader");

    private static void addConfigurationModule(Object configuration, String name, Object resolvedModule, ClassLoader thisLoader) {
        HashMap<String, Object> nameToModule = new HashMap<String, Object>((Map)StaticComponentContainer.Fields.getDirect(configuration, "nameToModule"));
        nameToModule.putIfAbsent(name, resolvedModule);
        StaticComponentContainer.Fields.setDirect(configuration, "nameToModule", Collections.unmodifiableMap(nameToModule));
        Object thisConfig = StaticComponentContainer.Fields.getDirect((Object)thisLoader, "configuration");
        ForgeCoreLoader.removeFromUnmodifiableSetField(thisConfig, "modules", resolvedModule);
        ForgeCoreLoader.removeFromUnmodifiableMapField(thisConfig, "nameToModule", name);
        StaticComponentContainer.Fields.setDirect(resolvedModule, "cf", thisConfig);
        HashMap<Object, Set> thisGraph = new HashMap<Object, Set>((Map)StaticComponentContainer.Fields.getDirect(thisConfig, "graph"));
        thisGraph.entrySet().removeIf(entry -> ForgeCoreLoader.resolvedName(entry.getKey()).equals(name));
        thisGraph.forEach((key, values) -> values.remove(resolvedModule));
        StaticComponentContainer.Fields.setDirect(thisConfig, "graph", thisGraph);
    }

    static void addModuleThouroughly(Object module, Object resolvedModule, Object moduleLayer, String name, Set<String> packages, Object moduleRef, ClassLoader target, boolean newFormat) {
        StaticComponentContainer.Fields.setDirect(module, "name", (Object)name);
        Object configuration = StaticComponentContainer.Fields.getDirect((Object)target, "configuration");
        Map resolvedRoots = (Map)StaticComponentContainer.Fields.getDirect((Object)target, newFormat ? "ourModules" : "resolvedRoots");
        Map packageLookup = (Map)StaticComponentContainer.Fields.getDirect((Object)target, newFormat ? "packageToOurModules" : "packageLookup");
        Map parentLoaders = (Map)StaticComponentContainer.Fields.getDirect((Object)target, newFormat ? "packageToParentLoader" : "parentLoaders");
        resolvedRoots.put(name, moduleRef);
        for (String pkg : packages) {
            packageLookup.put(pkg, resolvedModule);
        }
        parentLoaders.entrySet().removeIf(entry -> packages.contains(entry.getKey()));
        HashSet<Object> configModules = new HashSet<Object>((Collection)StaticComponentContainer.Fields.getDirect(configuration, "modules"));
        HashMap<String, Object> configNameToModule = new HashMap<String, Object>((Map)StaticComponentContainer.Fields.getDirect(configuration, "nameToModule"));
        configModules.removeIf(rm -> name.equals(ForgeCoreLoader.resolvedName(rm)));
        configModules.add(resolvedModule);
        configNameToModule.put(name, resolvedModule);
        StaticComponentContainer.Fields.setDirect(configuration, "modules", Collections.unmodifiableSet(configModules));
        StaticComponentContainer.Fields.setDirect(configuration, "nameToModule", Collections.unmodifiableMap(configNameToModule));
        HashSet<Object> layerModules = (HashSet<Object>)StaticComponentContainer.Fields.getDirect(moduleLayer, "modules");
        boolean found = false;
        if (Objects.nonNull(layerModules)) {
            layerModules = new HashSet<Object>(layerModules);
            for (Object e : layerModules) {
                String lName = ForgeCoreLoader.moduleName(e);
                if (!Objects.nonNull(lName) || !lName.equals(ForgeCoreLoader.moduleName(module))) continue;
                found = true;
            }
        }
        if (!found) {
            if (Objects.nonNull(layerModules)) {
                layerModules.add(module);
                StaticComponentContainer.Fields.setDirect(moduleLayer, "modules", layerModules);
            }
            HashMap<String, Object> layerNameToModule = new HashMap<String, Object>((Map)StaticComponentContainer.Fields.getDirect(moduleLayer, "nameToModule"));
            layerNameToModule.put(name, module);
            StaticComponentContainer.Fields.setDirect(moduleLayer, "nameToModule", Collections.unmodifiableMap(layerNameToModule));
        }
        StaticComponentContainer.Fields.setDirect(module, "layer", moduleLayer);
        StaticComponentContainer.Fields.setDirect(module, "loader", (Object)target);
        StaticComponentContainer.Fields.setDirect(resolvedModule, "cf", configuration);
    }

    private static void addResolvedModule(Object module, ClassLoader thisLoader, boolean newFormat) {
        ClassLoader loader = ForgeCoreLoader.bootLoader();
        Map roots = (Map)StaticComponentContainer.Fields.getDirect((Object)loader, newFormat ? "ourModules" : "resolvedRoots");
        Map packageLookup = (Map)StaticComponentContainer.Fields.getDirect((Object)loader, newFormat ? "packageToOurModules" : "packageLookup");
        Object reference = StaticComponentContainer.Methods.invokeDirect(module, "reference", new Object[0]);
        Object descriptor = StaticComponentContainer.Methods.invokeDirect(reference, "descriptor", new Object[0]);
        String name = (String)StaticComponentContainer.Methods.invokeDirect(descriptor, "name", new Object[0]);
        roots.put(name, reference);
        Set packages = (Set)StaticComponentContainer.Methods.invokeDirect(descriptor, "packages", new Object[0]);
        for (Object pkg : packages) {
            packageLookup.put(pkg, module);
        }
        ForgeCoreLoader.moveModuleToLayer(loader, "BOOT", "SERVICE", name);
        Map parentLoaders = (Map)StaticComponentContainer.Fields.getDirect((Object)thisLoader, newFormat ? "packageToParentLoader" : "parentLoaders");
        for (String pkg : packages) {
            parentLoaders.put(pkg, loader);
        }
        ForgeCoreLoader.addConfigurationModule(StaticComponentContainer.Fields.getDirect((Object)loader, "configuration"), name, module, thisLoader);
        Map theseRoots = (Map)StaticComponentContainer.Fields.getDirect((Object)thisLoader, newFormat ? "ourModules" : "resolvedRoots");
        theseRoots.remove(name);
        LOGGER.debug("Finished migrating module {} from the SERVICE layer to the BOOT layer", (Object)name);
    }

    public static ClassLoader bootLoader() {
        ClassLoader loader = Launcher.class.getClassLoader();
        return Objects.nonNull(loader) ? loader : ClassLoader.getSystemClassLoader();
    }

    static Object buildNewModuleDescriptor(String name, Object secureJar, List<String> usesServices) throws Throwable {
        LOGGER.info("Building new module descriptor for {}", (Object)name);
        HashSet packages = new HashSet((Collection)StaticComponentContainer.Methods.invokeDirect(secureJar, "getPackages", new Object[0]));
        Collection providers = (Collection)StaticComponentContainer.Methods.invokeDirect(secureJar, "getProviders", new Object[0]);
        Class<?> cDesc = Class.forName("java.lang.module.ModuleDescriptor");
        Object metadata = StaticComponentContainer.Fields.getDirect(secureJar, "metadata");
        String version = (String)StaticComponentContainer.Methods.invokeDirect(metadata, "version", new Object[0]);
        Object builder = StaticComponentContainer.Methods.invokeStaticDirect(cDesc, "newAutomaticModule", name);
        builder = StaticComponentContainer.Methods.invokeDirect(builder, "version", version);
        builder = StaticComponentContainer.Methods.invokeDirect(builder, "packages", packages);
        for (Object provider : providers) {
            Collection actualProviders = (Collection)StaticComponentContainer.Methods.invokeDirect(provider, "providers", new Object[0]);
            if (actualProviders.isEmpty()) continue;
            String service = (String)StaticComponentContainer.Methods.invokeDirect(provider, "serviceName", new Object[0]);
            StaticComponentContainer.Methods.invokeDirect(builder, "provides", service, new ArrayList(actualProviders));
        }
        for (String service : usesServices) {
            StaticComponentContainer.Methods.invokeDirect(builder, "uses", service);
        }
        Object desc = StaticComponentContainer.Methods.invokeDirect(builder, "build", new Object[0]);
        LOGGER.info("Finished building descriptor {}", desc);
        return desc;
    }

    static Map<?, ?> burningWaveProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("banner.hide", "true");
        properties.put("managed-logger.repository.enabled", "false");
        return properties;
    }

    public static void exportAllModules() throws Throwable {
        LOGGER.info("Exporting all modules");
        Class<?> mClass = Class.forName("java.lang.Module");
        for (String layerName : new String[]{"BOOT", "SERVICE", "PLUGIN", "GAME"}) {
            Object layer = ForgeCoreLoader.getModuleLayer(layerName);
            Map nameToModule = (Map)StaticComponentContainer.Fields.getDirect(layer, "nameToModule");
            for (Object module : nameToModule.values()) {
                Object descriptor = StaticComponentContainer.Fields.getDirect(module, "descriptor");
                Set pkgs = (Set)StaticComponentContainer.Fields.getDirect(descriptor, "packages");
                for (String pkg : pkgs) {
                    StaticComponentContainer.Methods.invokeStaticDirect(mClass, "addExportsToAll0", module, pkg);
                    StaticComponentContainer.Methods.invokeStaticDirect(mClass, "addExportsToAllUnnamed0", module, pkg);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    static void finalizeModule(String oldName, String newName, Object module, ClassLoader target, ClassLoader ... loaders) {
        void var10_12;
        String moduleName = ForgeCoreLoader.moduleName(module);
        HashSet<Class> allMoved = new HashSet<Class>();
        HashMap removals = new HashMap();
        ClassLoader[] classLoaderArray = loaders;
        int n = classLoaderArray.length;
        boolean bl = false;
        while (var10_12 < n) {
            ClassLoader loader = classLoaderArray[var10_12];
            HashSet classes = (HashSet)StaticComponentContainer.Fields.getDirect((Object)loader, "classes");
            if (!Objects.isNull(classes)) {
                classes = new HashSet(classes);
                for (Class c : classes) {
                    String name = ForgeCoreLoader.moduleName(StaticComponentContainer.Fields.getDirect((Object)c, "module"));
                    if (Objects.isNull(name) || !name.equals(oldName) && !name.equals(newName)) continue;
                    StaticComponentContainer.Fields.setDirect((Object)c, "classLoader", (Object)target);
                    allMoved.add(c);
                    removals.putIfAbsent(loader, new HashSet());
                    ((Collection)removals.get(loader)).add(c);
                    StaticComponentContainer.Fields.setDirect((Object)c, "module", module);
                }
            }
            ++var10_12;
        }
        Collection targetClasses = (Collection)StaticComponentContainer.Fields.getDirect((Object)target, "classes");
        for (Class clazz : targetClasses) {
            String name = ForgeCoreLoader.moduleName(StaticComponentContainer.Fields.getDirect((Object)clazz, "module"));
            if (!Objects.nonNull(moduleName) || !moduleName.equals(name)) continue;
            StaticComponentContainer.Fields.setDirect((Object)clazz, "module", module);
        }
        targetClasses.addAll(allMoved);
        for (Map.Entry entry : removals.entrySet()) {
            Collection classes = (Collection)StaticComponentContainer.Fields.getDirect(entry.getKey(), "classes");
            classes.removeAll((Collection)entry.getValue());
        }
    }

    static Class<?> findClassInHeirarchy(ClassLoader loader, String className) {
        Class<?> foundClass = null;
        ClassLoader searchIn = loader;
        while (Objects.nonNull(searchIn)) {
            try {
                foundClass = StaticComponentContainer.Driver.getClassByName(className, false, loader, StaticComponentContainer.Classes.getClass());
            }
            catch (Throwable t) {
                LOGGER.debug("Class not found in ClassLoader {} (name = {})", (Object)searchIn, (Object)className);
            }
            if (Objects.nonNull(foundClass)) break;
            searchIn = StaticComponentContainer.ClassLoaders.getParent(searchIn);
        }
        if (Objects.isNull(foundClass)) {
            LOGGER.error("Class {} not found in ClassLoader heirarchy for {}", (Object)className, (Object)loader);
            return null;
        }
        return foundClass;
    }

    public static Object[] findModuleLoaderForPackage(String pkg, ClassLoader[] loaders, boolean newFormat) {
        for (int i = 0; i < loaders.length; ++i) {
            ClassLoader loader = loaders[i];
            String name = i == 0 ? "BOOT" : (i == 1 ? "SERVICE" : "PLUGIN");
            Map lookup = (Map)StaticComponentContainer.Fields.getDirect((Object)loader, newFormat ? "packageToOurModules" : "packageLookup");
            Object resolvedModule = lookup.get(pkg);
            if (!Objects.nonNull(resolvedModule)) continue;
            return new Object[]{loader, resolvedModule, name};
        }
        return null;
    }

    public static void fixFirstEntryPoint() {
        if (ForgeCoreLoader.isJava8()) {
            ForgeCoreLoader.fixForJava8();
        } else {
            ForgeCoreLoader.fixForModuleSystem();
        }
    }

    private static void fixForJava8() {
        URL source = ClassHelper.getSourceURL(ForgeCoreLoader.class);
        if (!ClassHelper.loadURL((URLClassLoader)ForgeCoreLoader.bootLoader(), source)) {
            LOGGER.error("Failed to load source {}", (Object)source);
        }
    }

    private static void fixForModuleSystem() {
        Map packageLookup;
        ClassHelper.checkBurningWaveInit();
        String pkg = ConsulterSupplyFunction.class.getPackage().getName();
        ClassLoader thisLoader = ForgeCoreLoader.class.getClassLoader();
        boolean newFormat = false;
        try {
            packageLookup = (Map)StaticComponentContainer.Fields.getDirect((Object)thisLoader, "packageLookup");
        }
        catch (Fields.NoSuchFieldException ex) {
            packageLookup = (Map)StaticComponentContainer.Fields.getDirect((Object)thisLoader, "packageToOurModules");
            newFormat = true;
        }
        Object module = packageLookup.get(pkg);
        if (Objects.nonNull(module)) {
            ForgeCoreLoader.addResolvedModule(module, thisLoader, newFormat);
            packageLookup.entrySet().removeIf(entry -> module.equals(entry.getValue()));
        } else {
            LOGGER.fatal("FAILED TO GET RESOLVED MODULE FOR {}", (Object)pkg);
        }
    }

    static ArgumentHandler getArgumentHandler() {
        return (ArgumentHandler)StaticComponentContainer.Fields.getDirect((Object)Launcher.INSTANCE, "argumentHandler");
    }

    @Nullable
    public static Object getBootLoadedCoreAPI() {
        return ForgeCoreLoader.getCoreAPIReflectively(ForgeCoreLoader.bootLoader());
    }

    static Object getCoreAPIReflectively(ClassLoader loader) {
        try {
            return StaticComponentContainer.Fields.getStaticDirect(Class.forName(APICORE, false, loader), "INSTANCE");
        }
        catch (ClassNotFoundException ex) {
            LOGGER.debug("CoreAPI not found on {}", (Object)loader);
            return null;
        }
    }

    static <E extends Enum<E>> E getEnum(ClassLoader loader, String className, String name) {
        Class<?> foundClass = ForgeCoreLoader.findClassInHeirarchy(loader, className);
        return Objects.nonNull(foundClass) ? (E)ForgeCoreLoader.getEnum(foundClass, name) : null;
    }

    static <E extends Enum<E>> E getEnum(Class<?> enumClass, String name) {
        return (E)Enum.valueOf(enumClass, name);
    }

    static Object getLayer(String name) {
        ClassLoader loader = ForgeCoreLoader.bootLoader();
        String className = "cpw.mods.modlauncher.api.IModuleLayerManager$Layer";
        return ForgeCoreLoader.getEnum(loader, className, name);
    }

    static Object getLayerManager() {
        Environment env = Launcher.INSTANCE.environment();
        return ((Optional)StaticComponentContainer.Methods.invoke((Object)env, "findModuleLayerManager", new Object[0])).orElse(null);
    }

    static Object getModuleFromLayer(String layerName, String name) {
        return ((Map)StaticComponentContainer.Fields.getDirect(ForgeCoreLoader.getModuleLayer(layerName), "nameToModule")).get(name);
    }

    public static Object getModuleFromPackage(String pkg, String layerName, boolean newFormat) {
        Object layer = ForgeCoreLoader.getModuleLayer(layerName);
        Map packageLookup = (Map)StaticComponentContainer.Fields.get((Object)ForgeCoreLoader.layerClassLoader(layerName), newFormat ? "packageToOurModules" : "packageLookup");
        Object resolved = packageLookup.get(pkg);
        if (Objects.isNull(resolved)) {
            LOGGER.error("Cannot get module for pacakge {} since it does not exist in input layer {}!", (Object)pkg, (Object)layerName);
            return null;
        }
        Map nameToModule = (Map)StaticComponentContainer.Fields.getDirect(layer, "nameToModule");
        return nameToModule.get(ForgeCoreLoader.resolvedName(resolved));
    }

    static Object getModuleLayer(String name) {
        Object layerEnum = ForgeCoreLoader.getLayer(name);
        if (Objects.isNull(layerEnum)) {
            LOGGER.error("Layer not found for name {}!", (Object)name);
            return null;
        }
        Object layerManager = ForgeCoreLoader.getLayerManager();
        if (Objects.isNull(layerManager)) {
            LOGGER.error("IModuleLayerManager instance not found in environment!");
            return null;
        }
        return ((Optional)StaticComponentContainer.Methods.invoke(layerManager, "getLayer", layerEnum)).orElse(null);
    }

    static Object getServicesCatalog(Object moduleLayer) {
        Object langAccess = StaticComponentContainer.Fields.getStaticDirect(ServiceLoader.class, "LANG_ACCESS");
        return StaticComponentContainer.Methods.invokeDirect(langAccess, "getServicesCatalog", moduleLayer);
    }

    static String getVersionFromForgeVersion(String forgeVersion) {
        String ignore = "forge-";
        String actualVersion = forgeVersion.startsWith(ignore) ? forgeVersion.substring(ignore.length()) : forgeVersion;
        String version = "1.21.1";
        if (actualVersion.startsWith("49.")) {
            version = "1.20.4";
        } else if (actualVersion.startsWith("50.")) {
            version = "1.20.6";
        }
        LOGGER.info("Guessed mc version {} from forge version {}", (Object)version, (Object)forgeVersion);
        return version;
    }

    static String getVersionStr() {
        int i;
        ArgumentHandler handler = ForgeCoreLoader.getArgumentHandler();
        if (Objects.isNull(handler)) {
            return null;
        }
        Object[] rawArgs = (String[])StaticComponentContainer.Fields.getDirect((Object)handler, "args");
        if (Objects.isNull(rawArgs)) {
            LOGGER.error("Failed to find version using handler {}", (Object)handler);
            return null;
        }
        int versionIndex = -1;
        boolean found = false;
        for (i = 0; i < rawArgs.length; ++i) {
            if (!rawArgs[i].equals("--fml.mcVersion")) continue;
            versionIndex = i + 1;
            found = true;
            break;
        }
        if (found) {
            LOGGER.debug("Found fml.mcVersion arg at index {} -> {}", (Object)versionIndex, (Object)rawArgs[versionIndex]);
            return rawArgs[versionIndex];
        }
        LOGGER.debug("--fml.mcVersion was not found so the mc version will be guessed from --version instead");
        for (i = 0; i < rawArgs.length; ++i) {
            if (!rawArgs[i].equals("--version")) continue;
            versionIndex = i + 1;
            found = true;
            break;
        }
        if (found) {
            LOGGER.debug("Found forge version arg at index {}", (Object)versionIndex);
            return ForgeCoreLoader.getVersionFromForgeVersion((String)rawArgs[versionIndex]);
        }
        LOGGER.error("Failed to find fml.mcVersion or version flags from args {}", (Object)Arrays.toString(rawArgs));
        return null;
    }

    @Nullable
    static Object initCoreAPI(ClassLoader loader) {
        ClassHelper.checkBurningWaveInit();
        LOGGER.info("Starting CoreAPI init");
        Object bootInstance = ForgeCoreLoader.getBootLoadedCoreAPI();
        if (Objects.nonNull(bootInstance)) {
            LOGGER.info("Returning existing CoreAPI instance found in the BOOT layer");
            return bootInstance;
        }
        String version = ForgeCoreLoader.getVersionStr();
        Class<?> coreClass = ForgeCoreLoader.loadAPI(version);
        try {
            return coreClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            LOGGER.fatal("Caught reflection exception while trying to get CoreAPI instance as {}", coreClass, (Object)ex);
        }
        catch (Exception ex) {
            LOGGER.fatal("Unknown error while trying to get CoreAPI instance as {}", coreClass, (Object)ex);
        }
        LOGGER.fatal("Failed to initialize CoreAPI [Forge-{}] using {}", (Object)version, (Object)loader);
        return null;
    }

    public static boolean isJava8() {
        return System.getProperty("java.version").startsWith("1.");
    }

    public static ClassLoader layerClassLoader(String name) {
        Object layer = ForgeCoreLoader.getLayer(name);
        Object layerManager = ForgeCoreLoader.getLayerManager();
        if (Objects.isNull(layer) || Objects.isNull(layerManager)) {
            LOGGER.error("Layer manager or layer with name {} is null! Boot loader will be returned", (Object)name);
            return ForgeCoreLoader.bootLoader();
        }
        Map completedLayers = (Map)StaticComponentContainer.Fields.getDirect(layerManager, "completedLayers");
        ClassLoader loader = (ClassLoader)StaticComponentContainer.Fields.get(completedLayers.get(layer), "cl");
        LOGGER.debug("Returning ClassLoader for layer {} as {}", (Object)name, (Object)loader);
        return loader;
    }

    static Class<?> loadAPI(String version) {
        ClassLoader loader = ForgeCoreLoader.bootLoader();
        String className = ForgeCoreLoader.versionClassName("core.TILCoreForge", version);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, true, loader);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to load class {} for {}", (Object)className, (Object)loader, (Object)ex);
        }
        if (Objects.isNull(clazz)) {
            throw new RuntimeException("Failed to load CoreAPI instance [Forge-" + version + "]");
        }
        if (ForgeCoreLoader.isJava8()) {
            String forgeModLoading = "mods.thecomputerizer.theimpossiblelibrary.forge.core.loader.ForgeModLoading";
            try {
                Class.forName(forgeModLoading, true, loader);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to load class {} for {}", (Object)forgeModLoading, (Object)loader, (Object)ex);
            }
        }
        LOGGER.debug("Successfully loaded CoreAPI instance {}", clazz);
        return clazz;
    }

    static void loadNewModuleTo(@Nullable IModInfo mod, String targetLayerName, Set<String> finalizedPkgs, boolean newFormat) {
        if (Objects.isNull(mod)) {
            LOGGER.error("Cannot load module from nonexistent file!");
            return;
        }
        try {
            Object descriptor;
            IModFileInfo fileInfo = mod.getOwningFile();
            Object file = StaticComponentContainer.Methods.invokeDirect(fileInfo, "getFile", new Object[0]);
            Object secureJar = StaticComponentContainer.Methods.invokeDirect(file, "getSecureJar", new Object[0]);
            ClassLoader targetLoader = ForgeCoreLoader.layerClassLoader("GAME");
            String existingName = (String)StaticComponentContainer.Methods.invokeDirect(secureJar, "name", new Object[0]);
            String name = mod.getModId();
            Object layer = ForgeCoreLoader.getModuleLayer(targetLayerName);
            Map nameToModule = (Map)StaticComponentContainer.Fields.getDirect(layer, "nameToModule");
            Object module = nameToModule.get(existingName);
            if (Objects.isNull(module)) {
                module = nameToModule.get(name);
            }
            boolean existed = false;
            if (Objects.nonNull(module)) {
                LOGGER.info("Found existing module to set up for {}", (Object)name);
                existed = true;
            } else {
                LOGGER.info("Setting up new module with name {}", (Object)name);
            }
            if (Objects.nonNull(module)) {
                descriptor = StaticComponentContainer.Fields.getDirect(module, "descriptor");
                StaticComponentContainer.Fields.setDirect(descriptor, "name", (Object)name);
            } else {
                List usesServices = (List)StaticComponentContainer.Methods.invokeDirect(fileInfo, "usesServices", new Object[0]);
                descriptor = ForgeCoreLoader.buildNewModuleDescriptor(name, secureJar, usesServices);
            }
            String finderName = newFormat ? "net.minecraftforge.securemodules.SecureModuleFinder" : "cpw.mods.cl.JarModuleFinder";
            Class<?> fClass = Class.forName(finderName);
            Object finder = StaticComponentContainer.Constructors.newInstanceOf(fClass, newFormat ? Collections.singletonList(secureJar) : secureJar);
            Map refMap = (Map)StaticComponentContainer.Fields.getDirect(finder, newFormat ? "references" : "moduleReferenceMap");
            Object reference = refMap.get(existingName);
            URI uri = (URI)StaticComponentContainer.Fields.getDirect(reference, "location");
            Object config = StaticComponentContainer.Fields.getDirect((Object)targetLoader, "configuration");
            Class<?> refClass = reference.getClass().getSuperclass();
            Class<?> cResolved = Class.forName("java.lang.module.ResolvedModule");
            StaticComponentContainer.Fields.setDirect(reference, "descriptor", descriptor);
            Object resolvedModule = StaticComponentContainer.Constructors.newInstanceOf(cResolved, config, reference);
            Set<String> packages = new HashSet<String>(ForgeCoreLoader.resolvedPackages(resolvedModule));
            packages.removeAll(finalizedPkgs);
            packages = Collections.unmodifiableSet(packages);
            finalizedPkgs.addAll(packages);
            Class<?> cModule = Class.forName("java.lang.Module");
            if (Objects.isNull(module)) {
                module = StaticComponentContainer.Constructors.newInstanceOf(cModule, layer, targetLoader, descriptor, uri);
            }
            ForgeCoreLoader.addModuleThouroughly(module, resolvedModule, layer, name, packages, reference, targetLoader, newFormat);
            LOGGER.info("Finished setting up {}", module);
            ClassLoader boot = ForgeCoreLoader.bootLoader();
            ClassLoader service = ForgeCoreLoader.layerClassLoader("SERVICE");
            ClassLoader plugin = ForgeCoreLoader.layerClassLoader("PLUGIN");
            ForgeCoreLoader.nukeConfig(name, boot, service, plugin);
            ForgeCoreLoader.nukeLoaderFields(name, newFormat, boot, service, plugin);
            ForgeCoreLoader.nukeModuleLayer(name, "BOOT", "SERVICE", "PLUGIN");
            if (!existingName.equals(name) && existed) {
                ForgeCoreLoader.nukeConfig(existingName, boot, service, plugin, targetLoader);
                ForgeCoreLoader.nukeLoaderFields(existingName, newFormat, boot, service, plugin, targetLoader);
                ForgeCoreLoader.nukeModuleLayer(existingName, "BOOT", "SERVICE", "PLUGIN", "GAME");
            }
            ForgeCoreLoader.finalizeModule(existingName, name, module, targetLoader, boot, service, plugin);
            LOGGER.warn("------------------------------------------------------------------------------------------------");
            LOGGER.warn("SUCCESSFULLY LOADED {} TO THE GAME LAYER HAVE A NICE DAY", (Object)name);
            LOGGER.warn("------------------------------------------------------------------------------------------------");
        }
        catch (Throwable t) {
            LOGGER.error("Failed to load new module!", t);
        }
    }

    public static String moduleName(Object module) {
        return Objects.nonNull(module) ? (String)StaticComponentContainer.Methods.invokeDirect(module, "getName", new Object[0]) : null;
    }

    public static void moveModuleToLayer(ClassLoader targetLoader, String layerTo, String layerFrom, String moduleName) {
        Object to = ForgeCoreLoader.getModuleLayer(layerTo);
        if (Objects.isNull(to)) {
            LOGGER.error("Unable to move module {}! Cannot find target layer {}", (Object)moduleName, (Object)layerTo);
            return;
        }
        Object from = ForgeCoreLoader.getModuleLayer(layerFrom);
        if (Objects.isNull(from)) {
            LOGGER.error("Unable to move module {}! Cannot find supplier layer {}", (Object)moduleName, (Object)layerFrom);
            return;
        }
        String fieldName = "nameToModule";
        HashMap moduleMapFrom = new HashMap((Map)StaticComponentContainer.Fields.getDirect(from, fieldName));
        Object module = moduleMapFrom.get(moduleName);
        if (Objects.isNull(module)) {
            LOGGER.error("Unable to move module {}! Cannot find module in supplier layer {}", (Object)moduleName, (Object)layerFrom);
            return;
        }
        StaticComponentContainer.Fields.setDirect(module, "loader", (Object)targetLoader);
        StaticComponentContainer.Fields.setDirect(module, "layer", to);
        HashMap moduleMapTo = new HashMap((Map)StaticComponentContainer.Fields.getDirect(to, fieldName));
        moduleMapTo.putIfAbsent(moduleName, module);
        StaticComponentContainer.Fields.setDirect(to, fieldName, Collections.unmodifiableMap(moduleMapTo));
        moduleMapFrom.remove(moduleName);
        StaticComponentContainer.Fields.setDirect(from, fieldName, Collections.unmodifiableMap(moduleMapFrom));
    }

    public static void nukeAndFinalize(IModInfo mod, String pkg, Set<String> finalizedPkgs, boolean newFormat) {
        LOGGER.info("Finalizing package {}", (Object)pkg);
        ClassLoader boot = ForgeCoreLoader.bootLoader();
        ClassLoader service = ForgeCoreLoader.layerClassLoader("SERVICE");
        ClassLoader plugin = ForgeCoreLoader.layerClassLoader("PLUGIN");
        Object[] found = ForgeCoreLoader.findModuleLoaderForPackage(pkg, new ClassLoader[]{boot, service, plugin}, newFormat);
        if (Objects.isNull(found)) {
            ForgeCoreLoader.loadNewModuleTo(mod, "GAME", finalizedPkgs, newFormat);
            return;
        }
        ClassLoader foundLoader = (ClassLoader)found[0];
        Object resolvedModule = found[1];
        LOGGER.info("Got resolved module as {}", resolvedModule);
        String name = ForgeCoreLoader.resolvedName(resolvedModule);
        LOGGER.warn("------------------------------------------------------------------------------------------------");
        LOGGER.warn("NUKING ALL REFERENCES OF MODULE {} FROM THE BOOT, SERVICE, & PLUGIN LAYERS", (Object)name);
        LOGGER.warn("------------------------------------------------------------------------------------------------");
        Map bootRoots = (Map)StaticComponentContainer.Fields.getDirect((Object)foundLoader, newFormat ? "ourModules" : "resolvedRoots");
        Object ref = bootRoots.get(name);
        Object foundLayer = ForgeCoreLoader.getModuleLayer((String)found[2]);
        Map layerModules = (Map)StaticComponentContainer.Fields.getDirect(foundLayer, "nameToModule");
        Object module = layerModules.get(name);
        ClassLoader target = ForgeCoreLoader.layerClassLoader("GAME");
        Object moduleLayer = ForgeCoreLoader.getModuleLayer("GAME");
        Set<String> packages = new HashSet<String>(ForgeCoreLoader.resolvedPackages(resolvedModule));
        packages.removeAll(finalizedPkgs);
        packages = Collections.unmodifiableSet(packages);
        finalizedPkgs.addAll(packages);
        ForgeCoreLoader.addModuleThouroughly(module, resolvedModule, moduleLayer, name, packages, ref, target, newFormat);
        ForgeCoreLoader.nukeConfig(name, boot, service, plugin);
        ForgeCoreLoader.nukeLoaderFields(name, newFormat, boot, service, plugin);
        ForgeCoreLoader.nukeModuleLayer(name, "BOOT", "SERVICE", "PLUGIN");
        ForgeCoreLoader.finalizeModule(name, name, module, target, boot, service, plugin);
        LOGGER.warn("------------------------------------------------------------------------------------------------");
        LOGGER.warn("MODULE {} HAS BEEN SUCCESSFULLY MOVED TO THE GAME LAYER HAVE A NICE DAY", (Object)name);
        LOGGER.warn("------------------------------------------------------------------------------------------------");
    }

    public static void nukeAndFinalizeJava8(Set<Class<?>> getSourcesFrom, ClassLoader target, boolean first) {
        if (getSourcesFrom.isEmpty()) {
            LOGGER.error("No classes to get sources from!");
            return;
        }
        HashSet<String> sources = new HashSet<String>();
        for (Class<?> from : getSourcesFrom) {
            ClassHelper.addSource(sources, from);
        }
        CoreAPI core = CoreAPI.getInstance();
        if (first) {
            core.addSources(sources);
        }
        LOGGER.info("Adding {} sources to target loader {}", (Object)sources.size(), (Object)target);
        sources.forEach(source -> {
            LOGGER.info("Adding source {}", source);
            core.addURLToClassLoader(target, (String)source);
        });
    }

    static void nukeConfig(String name, ClassLoader ... loaders) {
        for (ClassLoader loader : loaders) {
            Object configuration = StaticComponentContainer.Fields.getDirect((Object)loader, "configuration");
            HashMap nameToModule = new HashMap((Map)StaticComponentContainer.Fields.getDirect(configuration, "nameToModule"));
            Object module = nameToModule.get(name);
            if (!Objects.nonNull(module)) continue;
            nameToModule.remove(name);
            StaticComponentContainer.Fields.setDirect(configuration, "nameToModule", Collections.unmodifiableMap(nameToModule));
            HashSet modules = new HashSet((Collection)StaticComponentContainer.Fields.getDirect(configuration, "modules"));
            modules.remove(module);
            StaticComponentContainer.Fields.setDirect(configuration, "modules", modules);
        }
    }

    static void nukeLoaderFields(String moduleName, boolean newFormat, ClassLoader ... loaders) {
        for (ClassLoader loader : loaders) {
            Set<String> packages;
            Map resolvedRoots = (Map)StaticComponentContainer.Fields.getDirect((Object)loader, newFormat ? "ourModules" : "resolvedRoots");
            Map packageLookup = (Map)StaticComponentContainer.Fields.getDirect((Object)loader, newFormat ? "packageToOurModules" : "packageLookup");
            Map parentLoaders = (Map)StaticComponentContainer.Fields.getDirect((Object)loader, newFormat ? "packageToParentLoader" : "parentLoaders");
            resolvedRoots.remove(moduleName);
            if (newFormat) {
                Map ourModulesSecure = (Map)StaticComponentContainer.Fields.getDirect((Object)loader, "ourModulesSecure");
                ourModulesSecure.remove(moduleName);
            }
            Object module = null;
            for (Map.Entry pkgEntry : packageLookup.entrySet()) {
                Object value = pkgEntry.getValue();
                if (!moduleName.equals(ForgeCoreLoader.resolvedName(value))) continue;
                module = value;
                break;
            }
            if (Objects.isNull(module) || Objects.isNull(packages = ForgeCoreLoader.resolvedPackages(module))) continue;
            Map packageToCodeSource = newFormat ? (Map)StaticComponentContainer.Fields.getDirect((Object)loader, "packageToCodeSource") : null;
            for (String pkg : packages) {
                packageLookup.remove(pkg);
                parentLoaders.remove(pkg);
                if (!newFormat) continue;
                packageToCodeSource.remove(pkg);
            }
        }
    }

    static void nukeModuleLayer(String name, String ... layers) {
        for (String layer : layers) {
            Object moduleLayer = ForgeCoreLoader.getModuleLayer(layer);
            HashMap nameToModule = new HashMap((Map)StaticComponentContainer.Fields.getDirect(moduleLayer, "nameToModule"));
            nameToModule.remove(name);
            StaticComponentContainer.Fields.setDirect(moduleLayer, "nameToModule", Collections.unmodifiableMap(nameToModule));
            HashSet<Object> modules = (HashSet<Object>)StaticComponentContainer.Fields.getDirect(moduleLayer, "modules");
            if (!Objects.nonNull(modules)) continue;
            modules = new HashSet<Object>(modules);
            modules.removeIf(m -> name.equals(ForgeCoreLoader.moduleName(m)));
            StaticComponentContainer.Fields.setDirect(moduleLayer, "modules", Collections.unmodifiableSet(modules));
        }
    }

    static ClassLoader platformLoader() {
        return (ClassLoader)StaticComponentContainer.Methods.invokeStaticDirect(ClassLoader.class, "getPlatformClassLoader", new Object[0]);
    }

    static void removeFromUnmodifiableMapField(Object object, String name, Object toRemove) {
        HashMap map = new HashMap((Map)StaticComponentContainer.Fields.getDirect(object, name));
        map.remove(toRemove);
        StaticComponentContainer.Fields.setDirect(object, name, Collections.unmodifiableMap(map));
    }

    static void removeFromUnmodifiableSetField(Object object, String name, Object toRemove) {
        HashSet set = new HashSet((Collection)StaticComponentContainer.Fields.getDirect(object, name));
        set.remove(toRemove);
        StaticComponentContainer.Fields.setDirect(object, name, Collections.unmodifiableSet(set));
    }

    public static void removeServiceFrom(String service, String impl, String layer) {
        ClassHelper.checkBurningWaveInit();
        LOGGER.info("Attempting to fix service {} (implementation of {})", (Object)impl, (Object)service);
        String moduleName = "theimpossiblelibrary";
        Object servicesCatalog = ForgeCoreLoader.getServicesCatalog(ForgeCoreLoader.getModuleLayer(layer));
        Class<?> pClass = ForgeCoreLoader.serviceProviderClass(servicesCatalog);
        HashMap map = new HashMap((Map)StaticComponentContainer.Fields.getDirect(servicesCatalog, "map"));
        if (map.containsKey(service)) {
            ((List)map.get(service)).removeIf(provider -> impl.equals(StaticComponentContainer.Methods.invokeDirect(provider, "providerName", new Object[0])));
        }
        LOGGER.info("Sucessfully removed all service providers from {} layer for {}", (Object)layer, (Object)impl);
    }

    static Object resolvedDescriptor(Object resolvedModule) {
        return StaticComponentContainer.Methods.invokeDirect(resolvedModule, "descriptor", new Object[0]);
    }

    static String resolvedName(Object resolvedModule) {
        return (String)StaticComponentContainer.Methods.invokeDirect(ForgeCoreLoader.resolvedDescriptor(resolvedModule), "name", new Object[0]);
    }

    static Set<String> resolvedPackages(Object resolvedModule) {
        return (Set)StaticComponentContainer.Fields.getDirect(ForgeCoreLoader.resolvedDescriptor(resolvedModule), "packages");
    }

    public static void resyncModules(ClassLoader loaderTo, String layerTo, ClassLoader loaderFrom) {
        Map fromPkg;
        if (ForgeCoreLoader.isJava8()) {
            return;
        }
        LOGGER.info("Resyncing module to {}", (Object)layerTo);
        String pkg = "mods.thecomputerizer.theimpossiblelibrary.forge.core";
        boolean newFormat = false;
        try {
            ClassHelper.checkBurningWaveInit();
            fromPkg = (Map)StaticComponentContainer.Fields.getDirect((Object)loaderFrom, "packageLookup");
        }
        catch (Fields.NoSuchFieldException ex) {
            fromPkg = (Map)StaticComponentContainer.Fields.getDirect((Object)loaderFrom, "packageToOurModules");
            newFormat = true;
        }
        Object fromModule = fromPkg.get("mods.thecomputerizer.theimpossiblelibrary.forge.core");
        Object fromCfg = StaticComponentContainer.Fields.getDirect((Object)loaderFrom, "configuration");
        if (!"PLUGIN".equals(layerTo)) {
            HashSet modules = new HashSet((Collection)StaticComponentContainer.Fields.getDirect(fromCfg, "modules"));
            modules.add(fromModule);
            StaticComponentContainer.Fields.setDirect(fromCfg, "modules", modules);
        }
        Map pkgs = (Map)StaticComponentContainer.Fields.getDirect((Object)loaderTo, newFormat ? "packageToOurModules" : "packageLookup");
        Object module = pkgs.get("mods.thecomputerizer.theimpossiblelibrary.forge.core");
        String name = ForgeCoreLoader.resolvedName(module);
        Map roots = (Map)StaticComponentContainer.Fields.getDirect((Object)loaderTo, newFormat ? "ourModules" : "resolvedRoots");
        Object config = StaticComponentContainer.Fields.getDirect((Object)loaderTo, "configuration");
        ForgeCoreLoader.removeFromUnmodifiableSetField(config, "modules", module);
        ForgeCoreLoader.removeFromUnmodifiableMapField(config, "nameToModule", name);
        Object reference = StaticComponentContainer.Methods.invokeDirect(module, "reference", new Object[0]);
        Object descriptor = StaticComponentContainer.Methods.invokeDirect(reference, "descriptor", new Object[0]);
        Set packages = (Set)StaticComponentContainer.Methods.invokeDirect(descriptor, "packages", new Object[0]);
        Object layer = ForgeCoreLoader.getModuleLayer(layerTo);
        HashMap map = new HashMap((Map)StaticComponentContainer.Fields.getDirect(layer, "nameToModule"));
        map.remove(name);
        StaticComponentContainer.Fields.setDirect(layer, "nameToModule", map);
        Map parentLoaders = (Map)StaticComponentContainer.Fields.getDirect((Object)loaderTo, newFormat ? "packageToParentLoader" : "parentLoaders");
        for (String p : packages) {
            parentLoaders.put(p, loaderFrom);
        }
        roots.remove(name);
        HashMap<Object, Set> graph = new HashMap<Object, Set>((Map)StaticComponentContainer.Fields.getDirect(config, "graph"));
        graph.remove(module);
        graph.forEach((key, values) -> values.remove(module));
        StaticComponentContainer.Fields.setDirect(config, "graph", graph);
        pkgs.entrySet().removeIf(entry -> module.equals(entry.getValue()));
    }

    public static void sanityCheckModule(Class<?> c, String name) {
        Object module = StaticComponentContainer.Methods.invokeDirect(c, "getModule", new Object[0]);
        String actualName = ForgeCoreLoader.moduleName(module);
        if (!name.equals(actualName)) {
            StaticComponentContainer.Fields.setDirect(c, "module", ForgeCoreLoader.getModuleFromLayer("GAME", name));
            LOGGER.info("Moved {} from module {} to module {}", c, (Object)actualName, (Object)name);
        }
    }

    @Nullable
    public static Class<?> serviceProviderClass(Object servicesCatalog) {
        if (Objects.isNull(servicesCatalog)) {
            return null;
        }
        Class<?> sClass = servicesCatalog.getClass();
        String providerClassName = sClass.getName() + "$ServiceProvider";
        try {
            return Class.forName(providerClassName);
        }
        catch (ClassNotFoundException ex) {
            LOGGER.error("Failed to find class {}", (Object)providerClassName, (Object)ex);
            return null;
        }
    }

    public static void verifyModule(String className, IModInfo info, Object moduleLayer) throws Exception {
        Optional optionalModule;
        LOGGER.info("Verifying that {} is valid for {} and can be found in {}", (Object)className, (Object)info, moduleLayer);
        IModFileInfo fileInfo = info.getOwningFile();
        String modid = info.getModId();
        String moduleName = (String)StaticComponentContainer.Methods.invokeDirect(fileInfo, "moduleName", new Object[0]);
        IModFile file = (IModFile)StaticComponentContainer.Methods.invokeDirect(fileInfo, "getFile", new Object[0]);
        if (!modid.equals(moduleName)) {
            LOGGER.error("Mod id {} does not equal module name {}!", (Object)modid, (Object)moduleName);
        }
        if (!(optionalModule = (Optional)StaticComponentContainer.Methods.invokeDirect(moduleLayer, "findModule", moduleName)).isPresent()) {
            Set modules = (Set)StaticComponentContainer.Methods.invokeDirect(moduleLayer, "modules", new Object[0]);
            for (Object module : modules) {
                String name = ForgeCoreLoader.moduleName(module);
                if (Objects.isNull(name) || !name.equals(moduleName) && !name.equals(modid)) continue;
                Object layer = StaticComponentContainer.Methods.invokeDirect(module, "getLayer", new Object[0]);
                boolean sameLayer = layer == moduleLayer;
                LOGGER.info("Found module {} in {} layer that wasn't present in the nameToModule map", (Object)moduleName, (Object)(sameLayer ? "the same" : "a different"));
                HashMap nameToModule = new HashMap((Map)StaticComponentContainer.Fields.getDirect(layer, "nameToModule"));
                nameToModule.put(moduleName, module);
                StaticComponentContainer.Fields.setDirect(layer, "nameToModule", Collections.unmodifiableMap(nameToModule));
                break;
            }
        }
        if (optionalModule.isPresent()) {
            String name;
            ClassLoader loader;
            Class<?> c;
            Object cModule;
            Object module = optionalModule.get();
            if (module != (cModule = StaticComponentContainer.Methods.invokeDirect(c = Class.forName(className, false, loader = (ClassLoader)StaticComponentContainer.Methods.invokeDirect(moduleLayer, "findLoader", name = ForgeCoreLoader.moduleName(module))), "getModule", new Object[0]))) {
                LOGGER.debug("Attempting to fix modules that are not equal");
                StaticComponentContainer.Fields.setDirect(c, "module", module);
            } else {
                LOGGER.debug("Modules are equal");
            }
        } else {
            LOGGER.error("Module {} is not present in the target layer!", (Object)moduleName);
        }
        LOGGER.info("Finished verifying {}", (Object)className);
    }

    static String versionClassName(String name, String version) {
        return ForgeCoreLoader.versionPackage(version) + "." + ForgeCoreLoader.versionQuantify(name, version);
    }

    static String versionPackage(String version) {
        String[] split = version.split("\\.");
        if (split.length < 3) {
            throw new RuntimeException("Can't parse package for unknown version " + version);
        }
        return "mods.thecomputerizer.theimpossiblelibrary.forge.v" + split[1] + ".m" + split[2];
    }

    static String versionQuantify(String name, String version) {
        return name + version.replace('.', '_');
    }

    static {
        if (ForgeCoreLoader.class.getClassLoader() != ForgeCoreLoader.bootLoader()) {
            if (ForgeCoreLoader.isJava8()) {
                LOGGER.info("I see you are running Java 8. Good choice, but I'll be using burningwave anyways");
            } else {
                LOGGER.info("I see you are running Java 9+ so I'll be using burningwave to break its strong encapsulation");
            }
        }
    }
}

