/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.common.event;

import java.util.Objects;
import javax.annotation.Nullable;
import mods.thecomputerizer.theimpossiblelibrary.api.common.event.EventWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;

public interface ForgeEventHelper {
    @Nullable
    default public IEventBus getBusFor(@Nullable Object wrapper) {
        if (Objects.isNull(wrapper)) {
            return MinecraftForge.EVENT_BUS;
        }
        String simpleName = wrapper.getClass().getSimpleName();
        return this.getBusFor(simpleName.substring(0, simpleName.indexOf("Event")));
    }

    @Nullable
    default public IEventBus getBusFor(String simpleClassName) {
        switch (simpleClassName) {
            case "RegisterBlockEntities": 
            case "RegisterBlocks": 
            case "RegisterEntities": 
            case "RegisterItems": 
            case "RegisterSounds": {
                return this.getModBus();
            }
        }
        return MinecraftForge.EVENT_BUS;
    }

    @Nullable
    default public IEventBus getModBus() {
        ModContainer container = ModLoadingContext.get().getActiveContainer();
        if (Objects.isNull(container)) {
            TILRef.logWarn("Active ModContainer not found for current context! Assuming context of {}", "theimpossiblelibrary");
            container = ModList.get().getModContainerById("theimpossiblelibrary").orElse(null);
        }
        if (Objects.isNull(container)) {
            TILRef.logError("Failed to get ModContainer! Event bus will not be returned", new Object[0]);
            return null;
        }
        return this.getModBus(container);
    }

    @Nullable
    public IEventBus getModBus(ModContainer var1);

    default public <E extends EventWrapper<?>> void registerForgeOrModBus(E wrapper) {
        IEventBus bus = this.getBusFor(wrapper);
        if (Objects.nonNull(bus)) {
            bus.register(wrapper.getClass());
        } else {
            TILRef.logError("Unable to find an event bus to register event wrapper {}", wrapper);
        }
    }
}

