/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.fabric.v19.core.loader;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.annotation.Nullable;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModCandidate;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModInfo;
import mods.thecomputerizer.theimpossiblelibrary.fabric.core.loader.MultiVersionLoaderFabric;

public class MultiVersionLoaderFabric1_19
extends MultiVersionLoaderFabric {
    public MultiVersionLoaderFabric1_19(CoreAPI parent) {
        super(parent);
    }

    @Override
    protected File findCoreModRoot() {
        return new File("mods");
    }

    @Override
    public File findModRoot() {
        return new File("mods");
    }

    @Override
    protected List<File> gatherCandidateModFiles(File root) {
        HashSet<File> set = new HashSet<File>();
        File[] mods = root.listFiles(file -> file.isFile() && file.getName().endsWith(".jar"));
        if (Objects.nonNull(mods)) {
            TILRef.logInfo("Adding {} potential mod files", mods.length);
            set.addAll(Arrays.asList(mods));
        } else {
            TILRef.logInfo("Adding 0 potential mod files", new Object[0]);
        }
        for (Path path : this.potentialModPaths) {
            File file2 = path.toFile();
            if (!file2.isFile() || !file2.getName().endsWith(".jar")) continue;
            set.add(file2);
        }
        return List.copyOf(set);
    }

    @Override
    @Nullable
    protected Attributes getFileAttributes(File file) {
        Attributes attributes;
        if (Objects.isNull(file) || !file.exists()) {
            return null;
        }
        JarFile jar = new JarFile(file);
        try {
            Manifest manifest = jar.getManifest();
            attributes = Objects.nonNull(manifest) ? manifest.getMainAttributes() : null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jar.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                TILRef.logError("Error getting attributes for jar file {}", file, ex);
                return null;
            }
        }
        jar.close();
        return attributes;
    }

    @Override
    protected MultiVersionModInfo loadModInfo(ClassLoader classLoader, MultiVersionModCandidate candidate, MultiVersionModInfo info) {
        return info;
    }
}

