/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.fabric.v19.common.block;

import java.util.Map;
import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.BlockHelperAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.BlockPropertyAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.fabric.v19.common.block.BlockProperty1_19;
import mods.thecomputerizer.theimpossiblelibrary.fabric.v19.common.block.Material1_19;
import mods.thecomputerizer.theimpossiblelibrary.fabric.v19.common.block.MaterialColor1_19;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3614;
import net.minecraft.class_3620;

public class BlockHelper1_19
implements BlockHelperAPI {
    static final Map<String, class_3620> COLOR_BY_NAME = BlockHelper1_19.buildColorMap();
    static final Map<String, class_3614> MATERIAL_BY_NAME = BlockHelper1_19.buildMaterialMap();

    static Map<String, class_3620> buildColorMap() {
        return Map.ofEntries(Map.entry("AIR", class_3620.field_16008), Map.entry("BLACK", class_3620.field_16009), Map.entry("BLACK_TERRACOTTA", class_3620.field_16007), Map.entry("BLUE", class_3620.field_15984), Map.entry("BLUE_TERRACOTTA", class_3620.field_16015), Map.entry("BROWN", class_3620.field_15977), Map.entry("BROWN_TERRACOTTA", class_3620.field_15992), Map.entry("CLAY", class_3620.field_15976), Map.entry("CYAN", class_3620.field_16026), Map.entry("CYAN_TERRACOTTA", class_3620.field_15990), Map.entry("DIAMOND", class_3620.field_15983), Map.entry("DIRT", class_3620.field_16000), Map.entry("EMERALD", class_3620.field_16001), Map.entry("FOLIAGE", class_3620.field_16004), Map.entry("GOLD", class_3620.field_15994), Map.entry("GRASS", class_3620.field_15999), Map.entry("GRAY", class_3620.field_15978), Map.entry("GRAY_TERRACOTTA", class_3620.field_16027), Map.entry("GREEN", class_3620.field_15995), Map.entry("GREEN_TERRACOTTA", class_3620.field_16028), Map.entry("ICE", class_3620.field_16016), Map.entry("LAPIS", class_3620.field_15980), Map.entry("LIGHT_BLUE", class_3620.field_16024), Map.entry("LIGHT_BLUE_TERRACOTTA", class_3620.field_15991), Map.entry("LIGHT_GRAY", class_3620.field_15993), Map.entry("LIGHT_GRAY_TERRACOTTA", class_3620.field_15988), Map.entry("LIME", class_3620.field_15997), Map.entry("LIME_TERRACOTTA", class_3620.field_16018), Map.entry("MAGENTA", class_3620.field_15998), Map.entry("MAGENTA_TERRACOTTA", class_3620.field_15985), Map.entry("METAL", class_3620.field_16005), Map.entry("NETHER", class_3620.field_16012), Map.entry("ORANGE", class_3620.field_15987), Map.entry("ORANGE_TERRACOTTA", class_3620.field_15981), Map.entry("PINK", class_3620.field_16030), Map.entry("PINK_TERRACOTTA", class_3620.field_15989), Map.entry("PURPLE", class_3620.field_16014), Map.entry("PURPLE_TERRACOTTA", class_3620.field_16029), Map.entry("QUARTZ", class_3620.field_16025), Map.entry("RED", class_3620.field_16020), Map.entry("RED_TERRACOTTA", class_3620.field_15982), Map.entry("SAND", class_3620.field_15986), Map.entry("SNOW", class_3620.field_16022), Map.entry("STONE", class_3620.field_16023), Map.entry("WATER", class_3620.field_16019), Map.entry("WHITE_TERRACOTTA", class_3620.field_16003), Map.entry("WOOL", class_3620.field_15979), Map.entry("WOOD", class_3620.field_15996), Map.entry("YELLOW", class_3620.field_16010), Map.entry("YELLOW_TERRACOTTA", class_3620.field_16013));
    }

    static Map<String, class_3614> buildMaterialMap() {
        return Map.ofEntries(Map.entry("AIR", class_3614.field_15959), Map.entry("ANVIL", class_3614.field_15949), Map.entry("BARRIER", class_3614.field_15952), Map.entry("CACTUS", class_3614.field_15925), Map.entry("CAKE", class_3614.field_15937), Map.entry("CLAY", class_3614.field_15936), Map.entry("CORAL", class_3614.field_15947), Map.entry("DIRT", class_3614.field_15941), Map.entry("DRAGON_EGG", class_3614.field_15930), Map.entry("EXPLOSIVE", class_3614.field_15955), Map.entry("FIRE", class_3614.field_15943), Map.entry("GLASS", class_3614.field_15942), Map.entry("VEGETABLE", class_3614.field_15954), Map.entry("GRASS", class_3614.field_15945), Map.entry("ICE", class_3614.field_15958), Map.entry("LAVA", class_3614.field_15922), Map.entry("LEAVES", class_3614.field_15923), Map.entry("METAL", class_3614.field_15953), Map.entry("PACKED_ICE", class_3614.field_15928), Map.entry("PISTON", class_3614.field_15933), Map.entry("PORTAL", class_3614.field_15919), Map.entry("SAND", class_3614.field_15916), Map.entry("SNOW", class_3614.field_15934), Map.entry("SNOW_LAYER", class_3614.field_15948), Map.entry("SPONGE", class_3614.field_15917), Map.entry("STONE", class_3614.field_15914), Map.entry("STRUCTURE_VOID", class_3614.field_15927), Map.entry("WATER", class_3614.field_15920), Map.entry("WEB", class_3614.field_15913), Map.entry("WOOL", class_3614.field_15931), Map.entry("WOOD", class_3614.field_15932));
    }

    @Override
    public <V extends Comparable<V>> BlockPropertyAPI<?, V> createProperty(String name, V defVal) {
        if (defVal instanceof Boolean) {
            return new BlockProperty1_19(class_2746.method_11825((String)name));
        }
        if (defVal instanceof Enum) {
            return new BlockProperty1_19(this.createPropertyEnum(name, defVal.getClass()));
        }
        if (defVal instanceof Number) {
            return new BlockProperty1_19(class_2758.method_11867((String)name, (int)0, (int)((Number)((Object)defVal)).intValue()));
        }
        TILRef.logError("Unsupported createProperty type for {}!", Objects.nonNull(defVal) ? defVal.getClass() : "null");
        return null;
    }

    private <E extends Enum<E>> class_2754<E> createPropertyEnum(String name, Class<?> clazz) {
        return class_2754.method_11850((String)name, clazz);
    }

    @Override
    public <P> BlockPropertyAPI<?, ?> getAsProperty(P property) {
        if (property instanceof class_2769) {
            return new BlockProperty1_19((class_2769)property);
        }
        TILRef.logError("Object {} is not an instance of {}!", property, class_2769.class);
        return null;
    }

    public Material1_19 getMaterialByName(String name) {
        class_3614 mat = TextHelper.isBlank(name) ? class_3614.field_15932 : MATERIAL_BY_NAME.getOrDefault(name, class_3614.field_15932);
        return new Material1_19(mat);
    }

    public MaterialColor1_19 getMaterialColorByName(String name) {
        class_3620 color = TextHelper.isBlank(name) ? class_3620.field_15999 : COLOR_BY_NAME.getOrDefault(name, class_3620.field_15999);
        return new MaterialColor1_19(color);
    }
}

