/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.fabric.v16.m5.world;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import mods.thecomputerizer.theimpossiblelibrary.api.common.biome.BiomeAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.BlockStateAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.blockentity.BlockEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.EntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.LivingEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemStackAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.structure.StructureAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.RegistryHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Box;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.DimensionAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.WrapperHelper;
import mods.thecomputerizer.theimpossiblelibrary.fabric.v16.m5.common.biome.Biome1_16_5;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3765;
import net.minecraft.class_4538;
import net.minecraft.class_5138;
import net.minecraft.util.IItemProvider;

public class World1_16_5
extends WorldAPI<class_1936> {
    public World1_16_5(Object world) {
        super((class_1936)world);
    }

    @Override
    public boolean canSnowAt(BlockPosAPI<?> api) {
        class_2338 pos = (class_2338)api.unwrap();
        return ((class_1936)this.wrapped).method_23753(pos).method_8696((class_4538)this.wrapped, pos);
    }

    @Override
    public BiomeAPI<?> getBiomeAt(BlockPosAPI<?> pos) {
        BiomeAPI biome = WrapperHelper.wrapBiome(((class_1936)this.wrapped).method_23753((class_2338)pos.unwrap()));
        ((Biome1_16_5)biome).setAccess(((class_1936)this.wrapped).method_30349());
        return biome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<BlockEntityAPI<?, ?>> getBlockEntitiesInBox(Box box) {
        ArrayList entities = new ArrayList();
        if (this.wrapped instanceof class_1937) {
            class_1936 class_19362 = (class_1936)this.wrapped;
            synchronized (class_19362) {
                for (class_2586 tile : ((class_1937)this.wrapped).field_9231) {
                    class_2338 pos = tile.method_11016();
                    if (!box.isInside(pos.method_10263(), pos.method_10264(), pos.method_10260())) continue;
                    entities.add(WrapperHelper.wrapBlockEntity(tile));
                }
            }
        }
        return entities;
    }

    @Override
    @Nullable
    public BlockEntityAPI<?, ?> getBlockEntityAt(BlockPosAPI<?> pos) {
        class_2586 tile = ((class_1936)this.wrapped).method_8321((class_2338)pos.unwrap());
        return Objects.nonNull(tile) ? WrapperHelper.wrapBlockEntity(tile) : null;
    }

    @Override
    public int getDayNumber() {
        return (int)((double)this.getTimeTotal() / 24000.0);
    }

    @Override
    public int getDifficultyOrdinal() {
        if (((class_1936)this.wrapped).method_8401().method_152()) {
            return 4;
        }
        switch (((class_1936)this.wrapped).method_8407()) {
            case field_5801: {
                return 0;
            }
            case field_5805: {
                return 1;
            }
            case field_5802: {
                return 2;
            }
            case field_5807: {
                return 3;
            }
        }
        return -1;
    }

    @Override
    public DimensionAPI<?> getDimension() {
        return WrapperHelper.wrapDimension(this, ((class_1936)this.wrapped).method_8597());
    }

    @Override
    public List<EntityAPI<?, ?>> getEntitiesInBox(Box box) {
        return this.getEntitiesInBox(new class_238(box.min.dX(), box.min.dY(), box.min.dZ(), box.max.dX(), box.max.dY(), box.max.dZ()));
    }

    private List<EntityAPI<?, ?>> getEntitiesInBox(Object box) {
        ArrayList entities = new ArrayList();
        for (class_1297 entity : ((class_1936)this.wrapped).method_18467(class_1297.class, (class_238)box)) {
            entities.add(WrapperHelper.wrapEntity(entity));
        }
        return entities;
    }

    @Override
    public int getLightBlock(BlockPosAPI<?> pos) {
        return ((class_1936)this.wrapped).method_8314(class_1944.field_9282, (class_2338)pos.unwrap());
    }

    @Override
    public int getLightSky(BlockPosAPI<?> pos) {
        return ((class_1936)this.wrapped).method_8314(class_1944.field_9284, (class_2338)pos.unwrap());
    }

    @Override
    public int getLightTotal(BlockPosAPI<?> pos) {
        return ((class_1936)this.wrapped).method_22336().method_22363((class_2338)pos.unwrap(), 0);
    }

    @Override
    public List<LivingEntityAPI<?, ?>> getLivingInBox(Box box) {
        return this.getLivingInBox(new class_238(box.min.dX(), box.min.dY(), box.min.dZ(), box.max.dX(), box.max.dY(), box.max.dZ()));
    }

    private List<LivingEntityAPI<?, ?>> getLivingInBox(Object box) {
        ArrayList entities = new ArrayList();
        for (class_1309 entity : ((class_1936)this.wrapped).method_18467(class_1309.class, (class_238)box)) {
            entities.add(WrapperHelper.wrapLivingEntity(entity));
        }
        return entities;
    }

    @Override
    public int getMoonPhase() {
        return ((class_1936)this.wrapped).method_30273();
    }

    private class_3765 getRaid(BlockPosAPI<?> pos) {
        return ((class_1936)this.wrapped).method_8608() ? null : ((class_3218)this.wrapped).method_19502((class_2338)pos.unwrap());
    }

    @Override
    @Nullable
    public String getRaidStatus(BlockPosAPI<?> pos) {
        class_3765 raid = this.getRaid(pos);
        if (Objects.isNull(raid)) {
            return null;
        }
        if (raid.method_20023()) {
            return "VICTORY";
        }
        if (raid.method_20024()) {
            return "LOSS";
        }
        if (raid.method_20022()) {
            return "STOPPED";
        }
        if (raid.method_16504()) {
            return "ONGOING";
        }
        return null;
    }

    @Override
    public int getRaidWave(BlockPosAPI<?> pos) {
        class_3765 raid = this.getRaid(pos);
        return Objects.nonNull(raid) ? raid.method_16490() : -1;
    }

    @Override
    public BlockStateAPI<?> getStateAt(BlockPosAPI<?> pos) {
        return WrapperHelper.wrapState(((class_1936)this.wrapped).method_8320((class_2338)pos.unwrap()));
    }

    @Override
    public StructureAPI<?> getStructureAt(BlockPosAPI<?> api) {
        if (this.wrapped instanceof class_3218) {
            class_5138 manager = ((class_3218)this.wrapped).method_27056();
            class_2338 pos = (class_2338)api.unwrap();
            for (Object structure : RegistryHelper.getStructureRegistry().getValues()) {
                if (!manager.method_28388(pos, false, (class_3195)structure).method_16657()) continue;
                return WrapperHelper.wrapStructure(structure);
            }
        }
        return null;
    }

    @Override
    public long getTimeDay() {
        return this.getTimeTotal() % 24000L;
    }

    @Override
    public long getTimeTotal() {
        return ((class_1936)this.wrapped).method_30271();
    }

    @Override
    public boolean isClient() {
        return ((class_1936)this.wrapped).method_8608();
    }

    @Override
    public boolean isDaytime() {
        return this.wrapped instanceof class_1937 && this.getTimeDay() < 13000L;
    }

    @Override
    public boolean isNighttime() {
        return this.wrapped instanceof class_1937 && this.getTimeDay() >= 13000L;
    }

    @Override
    public boolean isRaining() {
        return this.wrapped instanceof class_1937 && ((class_1937)this.wrapped).method_8419();
    }

    @Override
    public boolean isSkyVisible(BlockPosAPI<?> pos) {
        return ((class_1936)this.wrapped).method_8311((class_2338)pos.unwrap());
    }

    @Override
    public boolean isStorming() {
        return this.wrapped instanceof class_1937 && ((class_1937)this.wrapped).method_8546();
    }

    @Override
    public boolean isSunrise() {
        return this.getTimeDay() >= 23000L;
    }

    @Override
    public boolean isSunset() {
        long time = this.getTimeDay();
        return time >= 12000L && time < 13000L;
    }

    @Override
    public void setState(BlockPosAPI<?> pos, BlockStateAPI<?> state) {
        ((class_1936)this.wrapped).method_8652((class_2338)pos.unwrap(), (class_2680)state.unwrap(), 2);
    }

    @Override
    public void spawnEntity(EntityAPI<?, ?> entity, @Nullable Consumer<EntityAPI<?, ?>> onSpawn) {
        if (!((class_1936)this.wrapped).method_8608()) {
            ((class_1936)this.wrapped).method_8649((class_1297)entity.unwrapEntity());
            if (Objects.nonNull(onSpawn)) {
                onSpawn.accept(entity);
            }
        }
    }

    @Override
    public void spawnItem(ItemStackAPI<?> stack, Vector3 pos, @Nullable Consumer<EntityAPI<?, ?>> onSpawn) {
        if (this.wrapped instanceof class_1937 && !((class_1936)this.wrapped).method_8608()) {
            class_1542 item = new class_1542((class_1937)this.wrapped, pos.dX(), pos.dY(), pos.dZ(), (class_1799)stack.unwrap());
            item.method_6988();
            this.spawnEntity(WrapperHelper.wrapEntity(item), onSpawn);
        }
    }

    @Override
    public void spawnItem(ItemAPI<?> api, Vector3 pos, @Nullable Consumer<ItemStackAPI<?>> beforeSpawn, @Nullable Consumer<EntityAPI<?, ?>> onSpawn) {
        if (!((class_1936)this.wrapped).method_8608()) {
            ItemStackAPI stack = WrapperHelper.wrapItemStack(new class_1799((IItemProvider)api.unwrap()));
            if (Objects.nonNull(beforeSpawn)) {
                beforeSpawn.accept(stack);
            }
            this.spawnItem(stack, pos, onSpawn);
        }
    }
}

