/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.fabric.core.asm;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreEntryPoint;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.fabric.core.asm.TILFabricASMTarget;
import net.fabricmc.loader.api.MappingResolver;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.fabricmc.loader.impl.game.GameProvider;
import net.fabricmc.loader.impl.game.patch.GamePatch;
import net.fabricmc.loader.impl.game.patch.GameTransformer;
import net.fabricmc.loader.impl.launch.FabricLauncher;
import net.fabricmc.loader.impl.launch.FabricLauncherBase;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.objectweb.asm.tree.ClassNode;

public class TILFabricCoreModLoader
extends GamePatch {
    static void announcePatches(Collection<String> classNames) {
        TILFabricCoreModLoader.log(TILRef::logInfo, "Recalculated patch map for {}", classNames);
    }

    static String findMappedClass(MappingResolver mapper, String name) {
        return mapper.mapClassName("intermediary", name);
    }

    static void log(BiConsumer<String, Object[]> logger, String msg, Object ... args) {
        logger.accept("[Multiversion Transformer (Fabric)]: " + msg, args);
    }

    public static void patchTransformer(FabricLoaderImpl loader, CoreAPI core) {
        TILFabricCoreModLoader.registerEditors(core, TILDev.DEV ? null : loader.getMappingResolver());
        TILFabricCoreModLoader.log(TILRef::logInfo, "Adding coremod transformer patch", new Object[0]);
        GameProvider provider = loader.getGameProvider();
        TILFabricCoreModLoader.setupPatch(provider.getEntrypointTransformer(), (List)StaticComponentContainer.Fields.getDirect((Object)provider, "gameJars"));
        TILFabricCoreModLoader.log(TILRef::logInfo, "Finished adding coremod transformer patch", new Object[0]);
    }

    static void registerEditors(CoreAPI core, @Nullable MappingResolver mapper) {
        Set<CoreEntryPoint> entryPoints = core.getCoreInstances();
        TILFabricCoreModLoader.log(TILRef::logInfo, "Initializing {} coremod(s)", entryPoints.size());
        for (CoreEntryPoint entryPoint : entryPoints) {
            String name = entryPoint.getCoreName();
            TILFabricCoreModLoader.log(TILRef::logInfo, "Finding targets for {}", name);
            for (String target : entryPoint.classTargets()) {
                String mapped = Objects.nonNull(mapper) ? TILFabricCoreModLoader.findMappedClass(mapper, target) : target;
                TILFabricCoreModLoader.log(TILRef::logInfo, "[{}]: Adding class target {} (mapped {})", name, target, mapped);
                TILFabricASMTarget.registerEditor(mapped, entryPoint::editClass);
            }
        }
    }

    static void setupPatch(GameTransformer transformer, List<Path> gameJars) {
        ArrayList<TILFabricCoreModLoader> patches = new ArrayList<TILFabricCoreModLoader>((Collection)StaticComponentContainer.Fields.getDirect((Object)transformer, "patches"));
        patches.add(new TILFabricCoreModLoader());
        StaticComponentContainer.Fields.setDirect((Object)transformer, "patches", Collections.unmodifiableList(patches));
        StaticComponentContainer.Fields.setDirect((Object)transformer, "entrypointsLocated", (Object)false);
        transformer.locateEntrypoints(FabricLauncherBase.getLauncher(), gameJars);
        Map patchedClasses = (Map)StaticComponentContainer.Fields.getDirect((Object)transformer, "patchedClasses");
        TILFabricCoreModLoader.announcePatches(patchedClasses.keySet());
    }

    private TILFabricCoreModLoader() {
    }

    public void process(FabricLauncher launcher, Function<String, ClassNode> source, Consumer<ClassNode> emitter) {
        TILFabricASMTarget.runTransformers(source, emitter);
    }
}

