/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.util;

import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector2;

public class MathHelper {
    public static final double RADIANS_360 = Math.toRadians(360.0);
    public static final double RADIANS_270 = Math.toRadians(270.0);
    public static final double RADIANS_180 = Math.toRadians(180.0);
    public static final double RADIANS_90 = Math.toRadians(90.0);
    public static final double RADIANS_60 = Math.toRadians(60.0);
    public static final double RADIANS_45 = Math.toRadians(45.0);
    public static final double RADIANS_30 = Math.toRadians(30.0);

    public static double clamp(double val, double min, double max) {
        return Math.max(min, Math.min(val, max));
    }

    public static float clamp(float val, float min, float max) {
        return Math.max(min, Math.min(val, max));
    }

    public static int clamp(int val, int min, int max) {
        return Math.max(min, Math.min(val, max));
    }

    public static double cosFromSin(double sin, double angle) {
        double cos = Math.sqrt(1.0 - sin * sin);
        double a = angle + 1.5707963267948966;
        double pi2 = Math.PI * 2;
        double b = a - (double)((int)(a / pi2)) * pi2;
        if (b < 0.0) {
            b = pi2 + b;
        }
        return b >= Math.PI ? -cos : cos;
    }

    public static double distance(double ... values) {
        double total = 0.0;
        for (double value : values) {
            total += value * value;
        }
        return Math.sqrt(total);
    }

    public static double getBoundedAngle(double angle) {
        while (angle > RADIANS_180) {
            angle -= RADIANS_360;
        }
        while (angle < -RADIANS_180) {
            angle += RADIANS_360;
        }
        return angle;
    }

    public static double getHalfwayD(Vector2 vec) {
        return MathHelper.getHalfway(vec.dX(), vec.dY());
    }

    public static float getHalfwayF(Vector2 vec) {
        return MathHelper.getHalfway(vec.fX(), vec.fY());
    }

    public static double getHalfway(double start, double end) {
        return Math.min(start, end) + Math.abs(end - start) / 2.0;
    }

    public static float getHalfway(float start, float end) {
        return Math.min(start, end) + Math.abs(end - start) / 2.0f;
    }
}

