/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.toml;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.Toml;

public abstract class TomlRemapper {
    public boolean remap(Toml toml) {
        boolean remapped = this.remapTables(toml);
        remapped = this.remapEntries(toml) || remapped;
        remapped = this.remapChildren(toml) || remapped;
        return remapped;
    }

    public boolean remapChildren(Toml toml) {
        boolean remapped = false;
        for (Toml table : toml.getAllTables()) {
            TomlRemapper next = this.getNextRemapper(table.getName());
            if (!Objects.nonNull(next) || !next.remap(table)) continue;
            remapped = true;
        }
        return remapped;
    }

    public boolean remapEntries(Toml toml) {
        boolean remapped = false;
        HashMap mappedEntries = new HashMap();
        for (Toml.TomlEntry<?> tomlEntry : toml.getAllEntries()) {
            mappedEntries.put(tomlEntry, this.remapEntry(toml, tomlEntry));
        }
        for (Map.Entry entry : mappedEntries.entrySet()) {
            Toml.TomlEntry mapped;
            Toml.TomlEntry original = (Toml.TomlEntry)entry.getKey();
            if (original == (mapped = (Toml.TomlEntry)entry.getValue())) continue;
            remapped = true;
            toml.removeEntry(original.getKey());
            if (Objects.nonNull(original.getComments()) && Objects.nonNull(mapped)) {
                mapped.setComments(Arrays.asList(original.getComments()));
            }
            toml.addEntry(mapped);
        }
        return remapped;
    }

    public boolean remapTables(Toml toml) {
        boolean remapped = false;
        HashMap<String, String> mappedNames = new HashMap<String, String>();
        for (Toml toml2 : toml.getAllTables()) {
            mappedNames.put(toml2.getName(), this.remapTable(toml2.getName()));
        }
        for (Map.Entry entry : mappedNames.entrySet()) {
            if (((String)entry.getKey()).equals(entry.getValue())) continue;
            remapped = true;
            toml.remapTables((String)entry.getKey(), (String)entry.getValue());
        }
        return remapped;
    }

    @Nullable
    public abstract TomlRemapper getNextRemapper(String var1);

    public abstract String remapTable(String var1);

    public abstract Toml.TomlEntry<?> remapEntry(Toml var1, Toml.TomlEntry<?> var2);
}

