/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors;

import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;

public class Vector1
implements Vector {
    protected Number x;

    public static Vector1 get() {
        return Vector1.get(0);
    }

    public static Vector1 get(Number x) {
        return new Vector1(x);
    }

    public Vector1() {
        this(0);
    }

    public Vector1(Number x) {
        this.x = x;
    }

    @Override
    public Vector1 add(Vector v) {
        if (v.count() == 0) {
            return this;
        }
        this.setX(GenericUtils.numberAdd(this.x, v.x()));
        return this;
    }

    @Override
    public Vector1 addScalar(Number n) {
        this.setX(GenericUtils.numberAdd(this.x, n));
        return this;
    }

    @Override
    public double angle(Vector v) {
        return 0.0;
    }

    @Override
    public Number[] array() {
        return new Number[]{this.x};
    }

    @Override
    public byte[] bArrray() {
        return new byte[]{this.bX()};
    }

    @Override
    public Vector1 copy() {
        return new Vector1(this.x);
    }

    @Override
    public int count() {
        return 1;
    }

    @Override
    public Vector cross(Vector v) {
        throw new UnsupportedOperationException("Cannot perform cross product operation on Vector1");
    }

    @Override
    public double[] dArrray() {
        return new double[]{this.dX()};
    }

    @Override
    public double distance(Vector v) {
        return v.count() == 0 ? 0.0 : Math.abs(this.dX() - v.dX());
    }

    @Override
    public Vector1 div(Vector v) {
        if (v.count() == 0) {
            return this;
        }
        this.setX(GenericUtils.numberDiv(this.x, v.x()));
        return this;
    }

    @Override
    public Vector1 divScalar(Number n) {
        this.setX(GenericUtils.numberDiv(this.x, n));
        return this;
    }

    @Override
    public double dot(Vector v) {
        return v.count() == 0 ? 0.0 : this.dX() * v.dX();
    }

    @Override
    public float[] fArrray() {
        return new float[]{this.fX()};
    }

    @Override
    public int[] iArrray() {
        return new int[]{this.iX()};
    }

    @Override
    public long[] lArrray() {
        return new long[]{this.lX()};
    }

    @Override
    public Vector1 mul(Vector v) {
        if (v.count() == 0) {
            return this;
        }
        this.setX(GenericUtils.numberMul(this.x, v.x()));
        return this;
    }

    @Override
    public Vector1 mulScalar(Number n) {
        this.setX(GenericUtils.numberMul(this.x, n));
        return this;
    }

    @Override
    public short[] sArrray() {
        return new short[]{this.sX()};
    }

    @Override
    public void setW(Number w) {
        throw new UnsupportedOperationException("Cannot set w value for Vector1");
    }

    @Override
    public void setX(Number x) {
        this.x = x;
    }

    @Override
    public void setY(Number y) {
        throw new UnsupportedOperationException("Cannot set y value for Vector1");
    }

    @Override
    public void setZ(Number z) {
        throw new UnsupportedOperationException("Cannot set z value for Vector1");
    }

    @Override
    public Vector1 sub(Vector v) {
        if (v.count() == 0) {
            return this;
        }
        this.setX(GenericUtils.numberSub(this.x, v.x()));
        return this;
    }

    @Override
    public Vector1 subScalar(Number n) {
        this.setX(GenericUtils.numberSub(this.x, n));
        return this;
    }

    @Override
    public Vector vW() {
        throw new UnsupportedOperationException("Cannot get Vector1 W from Vector1");
    }

    @Override
    public Vector vX() {
        return this;
    }

    @Override
    public Vector vXW() {
        throw new UnsupportedOperationException("Cannot get Vector2 XW from Vector1");
    }

    @Override
    public Vector vXY() {
        throw new UnsupportedOperationException("Cannot get Vector2 XY from Vector1");
    }

    @Override
    public Vector vXYZ() {
        throw new UnsupportedOperationException("Cannot get Vector3 XYZ from Vector1");
    }

    @Override
    public Vector vXZ() {
        throw new UnsupportedOperationException("Cannot get Vector2 XZ from Vector1");
    }

    @Override
    public Vector vXZW() {
        throw new UnsupportedOperationException("Cannot get Vector3 XZW from Vector1");
    }

    @Override
    public Vector vY() {
        throw new UnsupportedOperationException("Cannot get Vector1 Y from Vector1");
    }

    @Override
    public Vector vYW() {
        throw new UnsupportedOperationException("Cannot get Vector2 YW from Vector1");
    }

    @Override
    public Vector vYZ() {
        throw new UnsupportedOperationException("Cannot get Vector2 YZ from Vector1");
    }

    @Override
    public Vector vYZW() {
        throw new UnsupportedOperationException("Cannot get Vector3 YZW from Vector1");
    }

    @Override
    public Vector vZ() {
        throw new UnsupportedOperationException("Cannot get Vector1 Z from Vector1");
    }

    @Override
    public Vector vZW() {
        throw new UnsupportedOperationException("Cannot get Vector2 ZW from Vector1");
    }

    @Override
    public Number w() {
        return Double.NaN;
    }

    @Override
    public Number x() {
        return this.x;
    }

    @Override
    public Number y() {
        return Double.NaN;
    }

    @Override
    public Number z() {
        return Double.NaN;
    }
}

