/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.resource;

import java.io.InputStream;
import java.util.Objects;
import javax.annotation.Nullable;
import mods.thecomputerizer.theimpossiblelibrary.api.common.CommonAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;

public class ResourceHelper {
    @Nullable
    public static ResourceAPI getResourceAPI() {
        return TILRef.getCommonSubAPI(CommonAPI::getResource);
    }

    @Nullable
    public static ResourceLocationAPI<?> getResource(String path) {
        ResourceAPI api = ResourceHelper.getResourceAPI();
        return Objects.nonNull(api) ? api.getLocation(path) : null;
    }

    @Nullable
    public static ResourceLocationAPI<?> getResource(String modid, String path) {
        ResourceAPI api = ResourceHelper.getResourceAPI();
        return Objects.nonNull(api) ? api.getLocation(modid, path) : null;
    }

    @Nullable
    @IndirectCallers
    public static InputStream getResourceStream(String path) {
        return ResourceHelper.getResourceStream(ResourceHelper.getResource(path));
    }

    @Nullable
    @IndirectCallers
    public static InputStream getResourceStream(String modid, String path) {
        return ResourceHelper.getResourceStream(ResourceHelper.getResource(modid, path));
    }

    @Nullable
    public static InputStream getResourceStream(@Nullable ResourceLocationAPI<?> location) {
        if (Objects.isNull(location)) {
            return null;
        }
        ResourceAPI api = ResourceHelper.getResourceAPI();
        return Objects.nonNull(api) ? api.stream(location) : null;
    }
}

