/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.network.message;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nullable;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ReflectionHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.network.NetworkHandler;
import mods.thecomputerizer.theimpossiblelibrary.api.network.NetworkHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageDirectionInfo;

public abstract class MessageWrapperAPI<PLAYER, CTX> {
    protected MessageDirectionInfo<?> info;
    private Collection<MessageAPI<CTX>> messages;
    private Collection<PLAYER> players;

    protected MessageWrapperAPI() {
    }

    protected MessageWrapperAPI(ByteBuf buf) {
        this.info = NetworkHandler.getDirectionInfo(NetworkHelper.readDir(buf));
        this.decode(buf);
    }

    public <DIR> MessageWrapperAPI<PLAYER, CTX> setMessage(DIR dir, MessageAPI<CTX> message) {
        this.info = NetworkHandler.getDirectionInfo(dir);
        this.messages = Collections.singletonList(message);
        return this;
    }

    @SafeVarargs
    public final <DIR> MessageWrapperAPI<PLAYER, CTX> setMessages(DIR dir, MessageAPI<CTX> ... messages) {
        return this.setMessages(dir, Arrays.asList(messages));
    }

    public <DIR> MessageWrapperAPI<PLAYER, CTX> setMessages(DIR dir, Collection<MessageAPI<CTX>> messages) {
        this.info = NetworkHandler.getDirectionInfo(dir);
        this.messages = Collections.unmodifiableCollection(messages);
        return this;
    }

    public MessageWrapperAPI<PLAYER, CTX> setPlayer(PLAYER player) {
        this.players = Collections.singletonList(player);
        return this;
    }

    @SafeVarargs
    public final MessageWrapperAPI<PLAYER, CTX> setPlayers(PLAYER ... players) {
        this.players = Arrays.asList(players);
        return this;
    }

    public MessageWrapperAPI<PLAYER, CTX> setPlayers(Collection<PLAYER> players) {
        this.players = Collections.unmodifiableCollection(players);
        return this;
    }

    public <DIR> void decode(ByteBuf buf) {
        this.messages = NetworkHelper.readCollection(buf, () -> {
            String name = NetworkHelper.readString(buf);
            Class<?> clazz = ReflectionHelper.findExtensibleClass(name, MessageAPI.class);
            return Objects.nonNull(clazz) ? (MessageAPI)this.info.decode(clazz, buf) : null;
        });
    }

    public void encode(ByteBuf buf) {
        if (Objects.isNull(this.messages)) {
            this.messages = Collections.emptyList();
        }
        NetworkHelper.writeDir(buf, this.info.getDirection());
        NetworkHelper.writeCollection(buf, this.messages, message -> {
            NetworkHelper.writeString(buf, message.getClass().getName());
            this.info.encode(message, buf);
        });
    }

    @Nullable
    public MessageWrapperAPI<PLAYER, CTX> handle(CTX context) {
        ArrayList replies = new ArrayList();
        for (MessageAPI<CTX> message : this.messages) {
            MessageAPI<CTX> reply = this.info.handle(message, context);
            if (!Objects.nonNull(reply)) continue;
            replies.add(reply);
        }
        return replies.isEmpty() ? null : NetworkHelper.wrapMessages(NetworkHelper.getOppositeDir(this.info.getDirection()), replies);
    }

    public void send() {
        if (Objects.isNull(this.info) || Objects.isNull(this.info.getDirection())) {
            TILRef.logError("Cannot send packet of class `{}` with null info or direction!", new Object[0]);
            return;
        }
        if (Objects.isNull(this.messages)) {
            TILRef.logError("Cannot send packet of class `{}` with no messages set!", new Object[0]);
            return;
        }
        if (NetworkHelper.isDirToClient(this.info.getDirection())) {
            if (Objects.isNull(this.players)) {
                TILRef.logError("Cannot send packet of class `{}` to client with no players set!", new Object[0]);
                return;
            }
            for (PLAYER player : this.players) {
                NetworkHelper.sendToPlayer(this, player);
            }
        } else {
            NetworkHelper.sendToServer(this);
        }
    }
}

