/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.network;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mods.thecomputerizer.theimpossiblelibrary.api.common.CommonAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.iterator.IterableHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.network.NetworkAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageDirectionInfo;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageWrapperAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.CompoundTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;

public class NetworkHelper {
    @Nullable
    public static <DIR> DIR getDirFromName(String name) {
        NetworkAPI api = NetworkHelper.getNetworkAPI();
        return Objects.nonNull(api) ? (DIR)api.getDirFromName(name) : null;
    }

    @Nullable
    public static <DIR> String getNameFromDir(DIR dir) {
        NetworkAPI api = NetworkHelper.getNetworkAPI();
        return Objects.nonNull(api) ? api.getNameFromDir(dir) : null;
    }

    @Nullable
    public static <DIR> DIR getDirToClient() {
        NetworkAPI api = NetworkHelper.getNetworkAPI();
        return Objects.nonNull(api) ? (DIR)api.getDirToClient() : null;
    }

    @Nullable
    public static <DIR> DIR getDirToClientLogin() {
        NetworkAPI api = NetworkHelper.getNetworkAPI();
        return Objects.nonNull(api) ? (DIR)api.getDirToClientLogin() : null;
    }

    @Nullable
    public static <DIR> DIR getDirToServer() {
        NetworkAPI api = NetworkHelper.getNetworkAPI();
        return Objects.nonNull(api) ? (DIR)api.getDirToServer() : null;
    }

    @Nullable
    public static <DIR> DIR getDirToServerLogin() {
        NetworkAPI api = NetworkHelper.getNetworkAPI();
        return Objects.nonNull(api) ? (DIR)api.getDirToServerLogin() : null;
    }

    @Nullable
    public static <DIR> DIR getOppositeDir(@Nullable DIR dir) {
        NetworkAPI api = NetworkHelper.getNetworkAPI();
        return Objects.nonNull(api) && Objects.nonNull(dir) ? (DIR)api.getOppositeDir(dir) : null;
    }

    @Nullable
    public static <N> N getNetwork() {
        NetworkAPI api = NetworkHelper.getNetworkAPI();
        return Objects.nonNull(api) ? (N)api.getNetwork() : null;
    }

    public static <N, DIR> NetworkAPI<N, DIR> getNetworkAPI() {
        return TILRef.getCommonSubAPI(CommonAPI::getNetwork);
    }

    public static <DIR> boolean isDirToClient(DIR d) {
        NetworkAPI api = NetworkHelper.getNetworkAPI();
        return Objects.nonNull(api) && api.isDirToClient(d);
    }

    public static <DIR> boolean isDirLogin(DIR d) {
        NetworkAPI api = NetworkHelper.getNetworkAPI();
        return Objects.nonNull(api) && api.isDirToClient(d);
    }

    public static Object parseObject(ByteBuf buf) {
        return NetworkHelper.parseObject(buf, null);
    }

    public static Object parseObject(ByteBuf buf, @Nullable Function<String, Object> fromString) {
        Class<?> valType;
        if (Objects.nonNull(fromString)) {
            return fromString.apply(NetworkHelper.readString(buf));
        }
        String className = NetworkHelper.readString(buf);
        try {
            valType = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            TILRef.logError("Could not find class name {} when parsing a generic object from a packet!", className, ex);
            throw new RuntimeException("Could not find class name when parsing a generic object from a packet!", ex);
        }
        return Collection.class.isAssignableFrom(valType) ? NetworkHelper.readCollection(buf, () -> NetworkHelper.parseObject(buf)) : GenericUtils.parseGenericType(NetworkHelper.readString(buf), valType);
    }

    public static <V> Collection<V> readCollection(ByteBuf buf, Supplier<V> valFunc) {
        String type;
        switch (type = NetworkHelper.readString(buf).toLowerCase()) {
            case "list": {
                return NetworkHelper.readList(buf, valFunc);
            }
            case "set": {
                return NetworkHelper.readSet(buf, valFunc);
            }
        }
        TILRef.logError("Tried to decode unsupported collection type: {}", type);
        return Collections.emptyList();
    }

    public static <DIR> DIR readDir(ByteBuf buf) {
        return NetworkHelper.getDirFromName(NetworkHelper.readString(buf));
    }

    public static <V> List<V> readList(ByteBuf buf, Supplier<V> valFunc) {
        ArrayList<V> ret = new ArrayList<V>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            ret.add(valFunc.get());
        }
        return ret;
    }

    public static <K, V> Map<K, V> readMapEntries(ByteBuf buf, Supplier<Map.Entry<K, V>> entryFunc) {
        HashMap<K, V> ret = new HashMap<K, V>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            Map.Entry<K, V> entry = entryFunc.get();
            ret.put(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    @IndirectCallers
    public static <K, V> Map<K, V> readMap(ByteBuf buf, Supplier<K> keyFunc, Supplier<V> valFunc) {
        return NetworkHelper.readMapEntries(buf, () -> IterableHelper.getMapEntry(keyFunc.get(), valFunc.get()));
    }

    @Nullable
    @IndirectCallers
    public static ResourceLocationAPI<?> readResourceLocation(ByteBuf buf) {
        NetworkAPI api = NetworkHelper.getNetworkAPI();
        return Objects.nonNull(api) ? api.readResourceLocation(buf) : null;
    }

    public static <V> Set<V> readSet(ByteBuf buf, Supplier<V> valFunc) {
        HashSet<V> ret = new HashSet<V>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            ret.add(valFunc.get());
        }
        return ret;
    }

    public static String readString(ByteBuf buf) {
        int strLength = buf.readInt();
        return strLength == 0 ? "" : (String)buf.readCharSequence(strLength, StandardCharsets.UTF_8);
    }

    @IndirectCallers
    public static CompoundTagAPI<?> readTag(ByteBuf buf) {
        return NetworkHelper.getNetworkAPI().readTag(buf);
    }

    public static <DIR> void registerMessage(MessageDirectionInfo<DIR> info, int id) {
        NetworkAPI api = NetworkHelper.getNetworkAPI();
        if (Objects.nonNull(api)) {
            api.registerMessage(info, id);
        }
    }

    public static <P, M extends MessageWrapperAPI<?, ?>> void sendToPlayer(M message, P player) {
        NetworkAPI api = NetworkHelper.getNetworkAPI();
        if (Objects.nonNull(api) && Objects.nonNull(message) && Objects.nonNull(player)) {
            api.sendToPlayer(message, player);
        }
    }

    public static <M extends MessageWrapperAPI<?, ?>> void sendToServer(M message) {
        NetworkAPI api = NetworkHelper.getNetworkAPI();
        if (Objects.nonNull(api) && Objects.nonNull(message)) {
            api.sendToServer(message);
        }
    }

    @Nullable
    public static <CTX, DIR> MessageWrapperAPI<?, CTX> wrapMessage(DIR dir, MessageAPI<CTX> message) {
        NetworkAPI api = NetworkHelper.getNetworkAPI();
        return Objects.nonNull(api) && Objects.nonNull(message) ? api.wrapMessage(dir, message) : null;
    }

    @Nullable
    public static <CTX, DIR> MessageWrapperAPI<?, CTX> wrapMessages(DIR dir, MessageAPI<CTX> ... messages) {
        NetworkAPI api = NetworkHelper.getNetworkAPI();
        if (Objects.nonNull(api) && Objects.nonNull(messages) && messages.length > 0) {
            return messages.length == 1 ? NetworkHelper.wrapMessage(dir, messages[0]) : api.wrapMessages(dir, messages);
        }
        return null;
    }

    @Nullable
    public static <CTX, DIR> MessageWrapperAPI<?, CTX> wrapMessages(DIR dir, Collection<MessageAPI<CTX>> messages) {
        NetworkAPI api = NetworkHelper.getNetworkAPI();
        return Objects.nonNull(api) && Objects.nonNull(messages) && !messages.isEmpty() ? api.wrapMessages(dir, messages) : null;
    }

    public static <V> void writeCollection(ByteBuf buf, Collection<V> collection, Consumer<V> valFunc) {
        if (collection instanceof List) {
            NetworkHelper.writeString(buf, "list");
            NetworkHelper.writeList(buf, (List)collection, valFunc);
        } else if (collection instanceof Set) {
            NetworkHelper.writeString(buf, "set");
            NetworkHelper.writeSet(buf, (Set)collection, valFunc);
        } else {
            NetworkHelper.writeString(buf, "list");
            buf.writeInt(collection.size());
            collection.forEach(valFunc);
        }
    }

    public static <DIR> void writeDir(ByteBuf buf, DIR dir) {
        String name = NetworkHelper.getNameFromDir(dir);
        NetworkHelper.writeString(buf, Objects.nonNull(name) ? name : "CLIENT");
    }

    public static <V> void writeList(ByteBuf buf, List<V> list, Consumer<V> valFunc) {
        buf.writeInt(list.size());
        list.forEach(valFunc);
    }

    @IndirectCallers
    public static <K, V> void writeMap(ByteBuf buf, Map<K, V> map, Consumer<K> keyFunc, Consumer<V> valFunc) {
        NetworkHelper.writeSet(buf, map.entrySet(), entry -> {
            keyFunc.accept(entry.getKey());
            valFunc.accept(entry.getValue());
        });
    }

    public static void writeObject(ByteBuf buf, Object val) {
        NetworkHelper.writeObject(buf, val, null);
    }

    public static void writeObject(ByteBuf buf, Object val, @Nullable Function<Object, String> toString) {
        if (Objects.nonNull(toString)) {
            NetworkHelper.writeString(buf, toString.apply(val));
        } else {
            NetworkHelper.writeString(buf, val.getClass().getName());
            if (val instanceof Collection) {
                NetworkHelper.writeCollection(buf, (Collection)val, element -> NetworkHelper.writeObject(buf, element));
            } else {
                NetworkHelper.writeString(buf, val.toString());
            }
        }
    }

    @IndirectCallers
    public static void writeResourceLocation(ByteBuf buf, ResourceLocationAPI<?> resource) {
        NetworkHelper.writeString(buf, resource.toString());
    }

    public static <V> void writeSet(ByteBuf buf, Set<V> set, Consumer<V> valFunc) {
        buf.writeInt(set.size());
        set.forEach(valFunc);
    }

    public static void writeString(ByteBuf buf, String string) {
        if (Objects.isNull(string) || string.isEmpty()) {
            TILRef.logError("Tried to write a null or empty string to a packet!", new Object[0]);
            buf.writeInt(0);
        }
        if (TextHelper.isNotBlank(string)) {
            ByteBuffer buffer = StandardCharsets.UTF_8.encode(string);
            string = StandardCharsets.UTF_8.decode(buffer).toString();
        }
        buf.writeInt(string.length());
        buf.writeCharSequence((CharSequence)string, StandardCharsets.UTF_8);
    }

    public static void writeTag(ByteBuf buf, CompoundTagAPI<?> tag) {
        NetworkHelper.getNetworkAPI().writeTag(buf, tag);
    }
}

