/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.iterator;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mods.thecomputerizer.theimpossiblelibrary.api.iterator.Mappable;
import mods.thecomputerizer.theimpossiblelibrary.api.iterator.Wrapperable;

public class WrapperableMappable<K, V>
extends Mappable<K, Wrapperable<V>> {
    public WrapperableMappable(Map<K, Wrapperable<V>> map, boolean isSynchronized) {
        super(map, isSynchronized);
    }

    public void add(@Nullable K key, V element) {
        Wrapperable val = (Wrapperable)this.get(key);
        if (Objects.nonNull(val)) {
            val.add(element);
        }
    }

    public void addIfAbsent(@Nullable K key, Wrapperable<V> val, V element) {
        if (Objects.nonNull(val = this.putIfAbsent(key, val))) {
            val.add(element);
        }
    }

    public boolean addIfUnmatched(@Nullable K key, Wrapperable<V> val, V element) {
        if (Objects.isNull(key) || this.matchesAnyValue(element)) {
            return false;
        }
        this.addIfAbsent(key, val, element);
        return true;
    }

    public boolean checkAllValues(Function<V, Boolean> func) {
        for (Wrapperable values : this.values()) {
            for (Object value : values) {
                if (!func.apply(value).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public void forAllValues(Consumer<V> consumer) {
        this.values().forEach((? super T wrapperable) -> wrapperable.forEach(consumer));
    }

    public K getKeyFromMatchingValue(Function<V, Boolean> matcher, K defVal) {
        for (Map.Entry entry : this) {
            for (Object val : (Wrapperable)entry.getValue()) {
                if (!matcher.apply(val).booleanValue()) continue;
                return entry.getKey();
            }
        }
        return defVal;
    }

    public V getMatchingValue(Function<V, Boolean> matcher, V defVal) {
        for (Wrapperable values : this.values()) {
            for (Object value : values) {
                if (!matcher.apply(value).booleanValue()) continue;
                return (V)value;
            }
        }
        return defVal;
    }

    public void insertFlatValues(Collection<V> output) {
        this.forAllValues(output::add);
    }

    public <C extends Collection<V>> C insertFlatValues(Supplier<C> outputSupplier) {
        Collection output = (Collection)outputSupplier.get();
        this.forAllValues(output::add);
        return (C)output;
    }

    public void insertMatchingValues(Collection<V> output, Function<V, Boolean> matcher) {
        this.forAllValues(val -> {
            if (((Boolean)matcher.apply(val)).booleanValue()) {
                output.add(val);
            }
        });
    }

    public <C extends Collection<V>> C insertMatchingValues(Supplier<C> outputSupplier, Function<V, Boolean> matcher) {
        Collection output = (Collection)outputSupplier.get();
        this.forAllValues(val -> {
            if (((Boolean)matcher.apply(val)).booleanValue()) {
                output.add(val);
            }
        });
        return (C)output;
    }

    public boolean matchesAnyValue(V other) {
        return this.checkAllValues(val -> Objects.equals(val, other));
    }

    public boolean matchesNone(V other) {
        return !this.matchesAnyValue(other);
    }

    public Wrapperable<V> putFast(@Nullable K key, Supplier<Iterable<V>> wrappableSupplier) {
        return this.putFast(key, wrappableSupplier.get());
    }

    public Wrapperable<V> putFast(@Nullable K key, Iterable<V> itr) {
        if (Objects.isNull(key)) {
            return new Wrapperable<V>(itr, false);
        }
        return this.put(key, new Wrapperable<V>(itr, false));
    }

    public Stream<V> parallelStreamAllValues() {
        return this.values().parallelStream().flatMap(Wrapperable::parallelStream);
    }

    public Stream<V> streamAllValues() {
        return this.values().stream().flatMap(Wrapperable::stream);
    }
}

