/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core.loader;

import java.io.File;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.common.CommonEntryPoint;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreEntryPoint;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.MultiVersionCoreMod;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.MultiVersionMod;
import mods.thecomputerizer.theimpossiblelibrary.api.io.FileHelper;

public class MultiVersionModCandidate {
    public static File loaderFile;
    private final CoreAPI core;
    private final boolean classpath;
    private final String relativePath;
    private final File file;
    private final URL source;
    private final Set<String> coreClassNames;
    private final Set<String> modClassNames;

    static File fromClassName(String className) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String asPath = ClassHelper.getResourcePath(className);
        try {
            return FileHelper.get(ClassHelper.absoluteLocation(loader.getResource(asPath), asPath));
        }
        catch (Exception ex) {
            TILRef.logError("Can't find file for {}", className, ex);
            return null;
        }
    }

    public MultiVersionModCandidate(CoreAPI core, String className) {
        this(core, MultiVersionModCandidate.fromClassName(className), className, true);
    }

    public MultiVersionModCandidate(CoreAPI core, File file) {
        this(core, file, file.getAbsolutePath(), false);
    }

    MultiVersionModCandidate(CoreAPI core, File file, String relativePath, boolean classpath) {
        this.core = core;
        this.classpath = classpath;
        this.relativePath = relativePath;
        this.file = Objects.nonNull(file) ? file : new File("theimpossiblelibrary-0.4.4.jar");
        this.source = FileHelper.toURL(this.file);
        this.coreClassNames = new HashSet<String>();
        this.modClassNames = new HashSet<String>();
    }

    public void addCoreClasses(Collection<String> foundCoreClasses, String ... classes) {
        TILRef.logDebug("Attempting to register {} coremod classes for file `{}` -> `{}`", classes.length, this.file, classes);
        for (String className : classes) {
            if (foundCoreClasses.contains(className)) {
                TILRef.logDebug("Skipping already known core class {}", className);
                continue;
            }
            foundCoreClasses.add(className);
            this.coreClassNames.add(className);
        }
    }

    public void addModClasses(Collection<String> foundModClasses, String ... classes) {
        TILRef.logDebug("Attempting to register {} mod classes for file `{}` -> `{}`", classes.length, this.file, classes);
        for (String className : classes) {
            if (foundModClasses.contains(className)) {
                TILRef.logDebug("Skipping already known mod class {}", className);
                continue;
            }
            foundModClasses.add(className);
            this.modClassNames.add(className);
        }
    }

    private boolean canBeAssigned(Class<?> clazz, Class<?> superClass) {
        if (superClass.isAssignableFrom(clazz)) {
            return true;
        }
        String superName = superClass.getName();
        Class<?> apparentSuper = clazz.getSuperclass();
        while (Objects.nonNull(apparentSuper)) {
            if (superName.equals(apparentSuper.getName())) {
                return true;
            }
            if (!Object.class.equals(apparentSuper = apparentSuper.getSuperclass())) continue;
            break;
        }
        return false;
    }

    public boolean canBeLoaded(@Nullable Class<?> clazz, Class<?> superClass, Class<? extends Annotation> annotation) {
        return Objects.nonNull(clazz) && this.canBeAssigned(clazz, superClass) && this.checkAnnotation(clazz, annotation);
    }

    private boolean checkAnnotation(Class<?> clazz, Class<? extends Annotation> annotation) {
        if (clazz.isAnnotationPresent(annotation)) {
            return true;
        }
        String name = annotation.getName();
        for (Annotation a : clazz.getAnnotations()) {
            if (!name.equals(a.annotationType().getName())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private Class<?> findClass(ClassLoader loader, String name) {
        ClassLoader coreLoader = CoreAPI.class.getClassLoader();
        TILRef.logInfo("Locating loader class {} (for = {} | core = {})", name, loader, coreLoader);
        Class<?> clazz = ClassHelper.existsOn(name, coreLoader);
        if (Objects.nonNull(clazz)) {
            return clazz;
        }
        CoreAPI core = CoreAPI.getInstance();
        CoreAPI.ModLoader modLoader = core.getModLoader();
        if (modLoader.isNeoForge() || modLoader.isForge() && !CoreAPI.isV16()) {
            String path = ClassHelper.getResourcePath(name);
            URL source = this.classpath ? loader.getResource(path) : ClassHelper.getJarResource(this.file.getAbsolutePath(), path);
            return ClassHelper.defineClass(coreLoader, name, source);
        }
        URL source = this.classpath ? ClassHelper.getSourceURL(name, loader) : this.source;
        core.addURLToClassLoader(loader, source);
        TILRef.logInfo("Added URL {} to loader {}", source, loader);
        return ClassHelper.findClass(name, loader);
    }

    public void findCoreClasses(Map<MultiVersionModCandidate, Collection<Class<? extends CoreEntryPoint>>> classes, MultiVersionModCandidate candidate, ClassLoader classLoader) {
        TILRef.logInfo("Finding coremod loader classes in file `{}`", this.file);
        ArrayList<Class<? extends CoreEntryPoint>> found = new ArrayList<Class<? extends CoreEntryPoint>>();
        this.findCoreClasses(found, classLoader);
        if (found.isEmpty()) {
            return;
        }
        classes.putIfAbsent(candidate, new ArrayList());
        classes.get(candidate).addAll(found);
    }

    public void findCoreClasses(Collection<Class<? extends CoreEntryPoint>> classes, ClassLoader classLoader) {
        for (String name : this.coreClassNames) {
            Class<?> clazz = this.findClass(classLoader, name);
            if (!this.canBeLoaded(clazz, CoreEntryPoint.class, MultiVersionCoreMod.class)) continue;
            classes.add(clazz);
        }
    }

    public void findModClasses(Map<MultiVersionModCandidate, Collection<Class<? extends CommonEntryPoint>>> classes, MultiVersionModCandidate candidate, ClassLoader classLoader) {
        TILRef.logInfo("Finding mod loader classes in file `{}`", this.file);
        ArrayList<Class<? extends CommonEntryPoint>> found = new ArrayList<Class<? extends CommonEntryPoint>>();
        this.findModClasses(found, classLoader);
        if (found.isEmpty()) {
            return;
        }
        classes.putIfAbsent(candidate, new ArrayList());
        classes.get(candidate).addAll(found);
    }

    public void findModClasses(Collection<Class<? extends CommonEntryPoint>> classes, ClassLoader classLoader) {
        for (String name : this.modClassNames) {
            Class<?> clazz = this.findClass(classLoader, name);
            if (!this.canBeLoaded(clazz, CommonEntryPoint.class, MultiVersionMod.class)) continue;
            classes.add(clazz);
        }
    }

    public boolean hasCoreMods() {
        return !this.coreClassNames.isEmpty();
    }

    public boolean hasMods() {
        return !this.modClassNames.isEmpty();
    }

    public void merge(MultiVersionModCandidate otherCandidate) {
        this.coreClassNames.addAll(otherCandidate.coreClassNames);
        this.modClassNames.addAll(otherCandidate.modClassNames);
    }

    @Generated
    public CoreAPI getCore() {
        return this.core;
    }

    @Generated
    public boolean isClasspath() {
        return this.classpath;
    }

    @Generated
    public String getRelativePath() {
        return this.relativePath;
    }

    @Generated
    public File getFile() {
        return this.file;
    }

    @Generated
    public URL getSource() {
        return this.source;
    }

    @Generated
    public Set<String> getCoreClassNames() {
        return this.coreClassNames;
    }

    @Generated
    public Set<String> getModClassNames() {
        return this.modClassNames;
    }
}

