/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.client.ClientAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.SharedHandlesClient;
import mods.thecomputerizer.theimpossiblelibrary.api.common.CommonAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.SharedHandlesCommon;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Reference;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TILRef {
    public static final String DATA_DIRECTORY = "impossible_data";
    public static final Logger LOGGER = LogManager.getLogger((String)"The Impossible Library");
    public static final String BASE_PACKAGE = "mods.thecomputerizer.theimpossiblelibrary";
    public static final String DESCRIPTION = "Multiversion API & mod loader with helpers to do things deemed impossible";
    public static final String MODID = "theimpossiblelibrary";
    public static final String NAME = "The Impossible Library";
    public static final String VERSION = "0.4.4";
    private static CommonAPI API;
    public static boolean CLIENT_ONLY;
    private static Reference INSTANCE;

    @Nullable
    public static ClientAPI getClientAPI() {
        CoreAPI core = CoreAPI.getInstance();
        if (core.getSide().isClient()) {
            if (Objects.isNull(API)) {
                core.initAPI();
            }
            return (ClientAPI)API;
        }
        TILRef.logError("The client API can only be retrieved from the client side!", new Object[0]);
        return null;
    }

    @Nullable
    public static <A> A getClientSubAPI(Function<ClientAPI, A> getter) {
        if (CoreAPI.isClient()) {
            return getter.apply(TILRef.getClientAPI());
        }
        TILRef.logError("Cannot get client sub API {} since this is not the client side!", new Object[0]);
        return null;
    }

    public static CommonAPI getCommonAPI() {
        if (Objects.isNull(API)) {
            CoreAPI.getInstance().initAPI();
        }
        return API;
    }

    public static <A> A getCommonSubAPI(Function<CommonAPI, A> getter) {
        return getter.apply(TILRef.getCommonAPI());
    }

    public static String getNetworkVersion() {
        return MODID + VERSION.replace('.', '_');
    }

    public static SharedHandlesClient getClientHandles() {
        return TILRef.getClientSubAPI(ClientAPI::getSharedHandlesClient);
    }

    public static SharedHandlesCommon getCommonHandles() {
        return TILRef.getCommonSubAPI(CommonAPI::getSharedHandlesCommon);
    }

    public static Reference instance(Supplier<Boolean> isClient, String dependencies) {
        if (Objects.isNull(INSTANCE)) {
            INSTANCE = new Reference(isClient.get(), dependencies, MODID, NAME, VERSION);
        }
        return INSTANCE;
    }

    @IndirectCallers
    public static void log(Level level, String msg, Object ... args) {
        TILRef.logNullable(level, msg, args);
    }

    public static void logDebug(String msg, Object ... args) {
        TILRef.logNullable(Level.DEBUG, msg, args);
    }

    public static void logError(String msg, Object ... args) {
        TILRef.logNullable(Level.ERROR, msg, args);
    }

    public static void logFatal(String msg, Object ... args) {
        TILRef.logNullable(Level.FATAL, msg, args);
    }

    public static void logInfo(String msg, Object ... args) {
        TILRef.logNullable(Level.INFO, msg, args);
    }

    private static void logNullable(Level level, String msg, Object ... args) {
        if (Objects.nonNull(INSTANCE)) {
            INSTANCE.log(level, msg, args);
        } else {
            LOGGER.log(level, msg, args);
        }
    }

    @IndirectCallers
    public static void logTrace(String msg, Object ... args) {
        TILRef.logNullable(Level.TRACE, msg, args);
    }

    public static void logWarn(String msg, Object ... args) {
        TILRef.logNullable(Level.WARN, msg, args);
    }

    public static ResourceLocationAPI<?> res(String path) {
        if (Objects.nonNull(INSTANCE)) {
            return INSTANCE.getResource(path);
        }
        throw new RuntimeException("Cannot get a ResourceLocation until the reference API has been initialized!");
    }

    @Generated
    public static void setAPI(CommonAPI API) {
        TILRef.API = API;
    }
}

