/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMRef;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public abstract class CoreEntryPoint {
    private InsnList list;
    private LabelNode label;

    protected CoreEntryPoint beginList(InsnList list) {
        this.list = list;
        return this;
    }

    public List<String> classTargets() {
        return Collections.emptyList();
    }

    public ClassNode editClass(ClassNode classNode) {
        return classNode;
    }

    public InsnList endList() {
        InsnList ret = this.list;
        this.list = null;
        return ret;
    }

    @IndirectCallers
    public abstract String getCoreID();

    public abstract String getCoreName();

    protected final String getClassName(ClassNode node) {
        return this.getClassName(node, false);
    }

    protected final String getClassName(ClassNode node, boolean asBinary) {
        return CoreAPI.getInstance().mapClassName(node.name, asBinary);
    }

    @IndirectCallers
    protected final String getFieldName(ClassNode classNode, FieldNode node) {
        return this.getFieldName(classNode, node, false);
    }

    protected final String getFieldName(ClassNode classNode, FieldNode node, boolean asBinary) {
        return CoreAPI.getInstance().mapFieldName(classNode.name, node.name, node.desc, asBinary);
    }

    protected final String getMethodName(ClassNode classNode, MethodNode node) {
        return this.getMethodName(classNode, node, false);
    }

    protected final String getMethodName(ClassNode classNode, MethodNode node, boolean asBinary) {
        return CoreAPI.getInstance().mapMethodName(classNode.name, node.name, node.desc, asBinary);
    }

    public CoreEntryPoint insBasic(int opcode) {
        if (Objects.isNull(this.list)) {
            TILRef.logError("Tried to insert basic instruction before calling beginList", new Object[0]);
        } else {
            this.list.add((AbstractInsnNode)new InsnNode(opcode));
        }
        return this;
    }

    public CoreEntryPoint insField(int opcode, String owner, String name, String desc) {
        if (Objects.isNull(this.list)) {
            TILRef.logError("Tried to insert field instruction before calling beginList", new Object[0]);
        } else {
            this.list.add((AbstractInsnNode)new FieldInsnNode(opcode, owner, name, desc));
        }
        return this;
    }

    public CoreEntryPoint insIf(int opcode, Label label) {
        if (Objects.isNull(this.list)) {
            TILRef.logError("Tried to insert if instruction before calling beginList", new Object[0]);
        } else if (Objects.isNull(label)) {
            TILRef.logError("Tried to insert with null label", new Object[0]);
        } else {
            this.label = new LabelNode(label);
            this.list.add((AbstractInsnNode)new JumpInsnNode(opcode, this.label));
        }
        return this;
    }

    public CoreEntryPoint insInvokeInterface(String owner, String name) {
        return this.insInvokeInterface(owner, name, ASMRef.EMPTY_METHOD_DESC);
    }

    public CoreEntryPoint insInvokeInterface(String owner, String name, String desc) {
        return this.insMethod(185, owner, name, desc, true);
    }

    public CoreEntryPoint insInvokeSpecial(String owner, String name) {
        return this.insInvokeSpecial(owner, name, ASMRef.EMPTY_METHOD_DESC);
    }

    public CoreEntryPoint insInvokeSpecial(String owner, String name, String desc) {
        return this.insMethod(183, owner, name, desc, false);
    }

    @IndirectCallers
    public CoreEntryPoint insInvokeStatic(String owner, String name) {
        return this.insInvokeStatic(owner, name, ASMRef.EMPTY_METHOD_DESC);
    }

    public CoreEntryPoint insInvokeStatic(String owner, String name, String desc) {
        return this.insMethod(184, owner, name, desc, false);
    }

    @IndirectCallers
    public CoreEntryPoint insInvokeVirtual(String owner, String name) {
        return this.insInvokeVirtual(owner, name, ASMRef.EMPTY_METHOD_DESC);
    }

    public CoreEntryPoint insInvokeVirtual(String owner, String name, String desc) {
        return this.insMethod(182, owner, name, desc, false);
    }

    public CoreEntryPoint insLabel() {
        if (Objects.isNull(this.list)) {
            TILRef.logError("Tried to insert label instruction before calling beginList", new Object[0]);
        } else if (Objects.isNull(this.label)) {
            TILRef.logError("Tried to insert uninitialized label instruction", new Object[0]);
        } else {
            this.list.add((AbstractInsnNode)this.label);
        }
        this.label = null;
        return this;
    }

    @IndirectCallers
    public CoreEntryPoint insLDC(Object object) {
        if (Objects.isNull(this.list)) {
            TILRef.logError("Tried to insert constant before calling beginList", new Object[0]);
        } else {
            this.list.add((AbstractInsnNode)new LdcInsnNode(object));
        }
        return this;
    }

    private CoreEntryPoint insMethod(int opcode, String owner, String name, String desc, boolean isInterface) {
        if (Objects.isNull(this.list)) {
            TILRef.logError("Tried to insert method instruction before calling beginList", new Object[0]);
        } else {
            this.list.add((AbstractInsnNode)new MethodInsnNode(opcode, owner, name, desc, isInterface));
        }
        return this;
    }

    public CoreEntryPoint insThis() {
        return this.insVar(25, 0);
    }

    public CoreEntryPoint insType(int opcode, String owner) {
        if (Objects.isNull(this.list)) {
            TILRef.logError("Tried to insert type instruction before calling beginList", new Object[0]);
        } else {
            this.list.add((AbstractInsnNode)new TypeInsnNode(opcode, owner));
        }
        return this;
    }

    public CoreEntryPoint insVar(int opcode, int index) {
        if (Objects.isNull(this.list)) {
            TILRef.logError("Tried to insert var instruction before calling beginList", new Object[0]);
        } else {
            this.list.add((AbstractInsnNode)new VarInsnNode(opcode, index));
        }
        return this;
    }

    protected boolean isTarget(ClassNode node) {
        for (String target : this.classTargets()) {
            if (!this.getClassName(node).equals(this.toInternal(target))) continue;
            return true;
        }
        return false;
    }

    @IndirectCallers
    protected String toBinary(String name) {
        return name.replace('/', '.');
    }

    protected String toDesc(String name) {
        return "L" + this.toInternal(name) + ";";
    }

    protected String toInternal(String name) {
        return name.replace('.', '/');
    }

    protected String toSignature(String outer, String inner) {
        return this.toDesc(outer + "<" + this.toDesc(inner) + ">");
    }

    public String toString() {
        return "CoreEntryPoint[" + this.getCoreName() + "]";
    }

    @Nullable
    @IndirectCallers
    public final byte[] transform(byte[] byteCode) {
        return this.transform(byteCode, 0);
    }

    @Nullable
    public final byte[] transform(byte[] byteCode, int writerFlags) {
        ClassNode node = ASMHelper.toClassNode(byteCode);
        this.editClass(node);
        return ASMHelper.toBytes(node, writerFlags);
    }
}

