/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core;

import io.github.toolfactory.jvm.util.BufferHandler;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ArrayHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ReflectionHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.io.FileHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Misc;
import org.burningwave.core.assembler.StaticComponentContainer;

public class ClassHelper {
    private static boolean burningWaveInit;

    public static URL absoluteLocation(@Nullable URL url, String className) {
        String locationStr = ClassHelper.absoluteLocationStr(url, className);
        return Objects.nonNull(locationStr) ? FileHelper.toURL(locationStr) : null;
    }

    @Nullable
    public static String absoluteLocationStr(@Nullable URL url, String className) {
        if (Objects.isNull(url)) {
            TILRef.logError("Cannot extract class path of null URL for {}!", className);
            return null;
        }
        String urlStr = url.toString().replace("%20", " ");
        String appended = (urlStr.startsWith("jar") ? "!/" : "/") + className;
        return urlStr.substring(urlStr.indexOf("/"), urlStr.length() - appended.length());
    }

    public static void addSource(Set<String> sources, Class<?> clazz) {
        URL url = ClassHelper.getSourceURL(clazz);
        if (Objects.nonNull(url)) {
            sources.add(url.toString());
        } else {
            TILRef.logError("Failed to add source for {}", clazz);
        }
    }

    @IndirectCallers
    public static boolean addSourceTo(Class<?> c, ClassLoader to) {
        if (c.getClassLoader() == to) {
            TILRef.logError("Source for {} already exists on {}!", c, to);
            return false;
        }
        boolean added = false;
        URL source = ClassHelper.getSourceURL(c);
        CoreAPI core = CoreAPI.getInstance();
        if (Objects.nonNull(core)) {
            added = core.addURLToClassLoader(to, source);
        } else if (to instanceof URLClassLoader) {
            added = ClassHelper.loadURL((URLClassLoader)to, source);
        } else {
            TILRef.logError("Failed to add source for {} to {}!", c, to);
        }
        return added;
    }

    public static Map<?, ?> burningWaveProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("banner.hide", "true");
        properties.put("managed-logger.repository.enabled", "false");
        return properties;
    }

    public static void checkBurningWaveInit() {
        if (!burningWaveInit) {
            try {
                StaticComponentContainer.Configuration.Default.add(ClassHelper.burningWaveProperties());
            }
            catch (Throwable t) {
                TILRef.logWarn("Tried to set default BurningWave properties twice", new Object[0]);
            }
            burningWaveInit = true;
        }
    }

    public static String className(@Nullable Object obj) {
        return ClassHelper.className(Objects.nonNull(obj) ? obj.getClass() : null, false);
    }

    public static String className(@Nullable Class<?> clazz) {
        return ClassHelper.className(clazz, false);
    }

    public static String className(@Nullable Object obj, boolean simple) {
        return ClassHelper.className(Objects.nonNull(obj) ? obj.getClass() : null, simple);
    }

    public static String className(@Nullable Class<?> clazz, boolean simple) {
        return Objects.nonNull(clazz) ? (simple ? clazz.getSimpleName() : clazz.getName()) : "";
    }

    @Nullable
    public static Class<?> defineAndResolveClass(ClassLoader loader, String name, byte[] byteCode) {
        return ClassHelper.resolveClass(loader, ClassHelper.defineClass(loader, name, byteCode));
    }

    @Nullable
    public static Class<?> defineClass(ClassLoader loader, String name, URL url) {
        if (Objects.nonNull(url)) {
            TILDev.logInfo("Attempting to define class {} from URL {} on loader {}", name, url, loader);
            try {
                ClassHelper.checkBurningWaveInit();
                return ClassHelper.defineClass(loader, name, StaticComponentContainer.Streams.toByteBuffer(url.openStream()));
            }
            catch (IOException ex) {
                TILRef.logError("Failed to open stream from URL {}", url, ex);
            }
        } else {
            TILRef.logError("Cannot define class at null URL on {}", loader);
        }
        return null;
    }

    public static Class<?> defineClass(ClassLoader loader, String className, @Nullable byte[] bytes) {
        return ClassHelper.defineClass(loader, className, Objects.nonNull(bytes) ? ByteBuffer.wrap(bytes) : null);
    }

    public static Class<?> defineClass(ClassLoader loader, String name, @Nullable ByteBuffer buffer) {
        if (Objects.isNull(buffer)) {
            throw new NullPointerException("Tried to define class with null ByteBuffer: " + name);
        }
        try {
            ClassHelper.checkBurningWaveInit();
            return StaticComponentContainer.ClassLoaders.loadOrDefineByByteCode(buffer, loader);
        }
        catch (Throwable t) {
            TILRef.logError("Failed to define class {} on {}", name, loader, t);
            return null;
        }
    }

    public static String descriptor(Class<?> clazz) {
        return Objects.nonNull(clazz) ? ClassHelper.descriptor(clazz.getName()) : "";
    }

    public static String descriptor(String classpath) {
        return TextHelper.isNotBlank(classpath) ? "L" + ClassHelper.internalName(classpath) + ";" : "";
    }

    public static Class<?> existsOn(String name, ClassLoader loader) {
        if (Objects.isNull(name) || name.isEmpty()) {
            TILRef.logWarn("Tried to check if class with null or empty name exists on {}", loader);
            return null;
        }
        try {
            return Class.forName(name, false, loader);
        }
        catch (ClassNotFoundException ex) {
            TILDev.logDebug("Class `{}` does not exist on {}", name, loader);
            return null;
        }
    }

    @Nullable
    public static Class<?> findClass(String name) {
        return ClassHelper.findClass(name, true, Thread.currentThread().getContextClassLoader(), false);
    }

    @Nullable
    public static Class<?> findClass(String name, ClassLoader classLoader) {
        return ClassHelper.findClass(name, true, classLoader, false);
    }

    @Nullable
    public static Class<?> findClass(String name, boolean initialize) {
        return ClassHelper.findClass(name, initialize, Thread.currentThread().getContextClassLoader(), false);
    }

    @Nullable
    @IndirectCallers
    public static Class<?> findClass(String name, boolean initialize, ClassLoader classLoader) {
        return ClassHelper.findClass(name, initialize, classLoader, false);
    }

    @Nullable
    public static Class<?> findClass(String name, boolean initialize, ClassLoader classLoader, boolean forceLoader) {
        if (Objects.isNull(name) || name.isEmpty()) {
            TILRef.logError("Cannot find class from null or blank name!", new Object[0]);
            return null;
        }
        try {
            Class<?> c = Class.forName(name, initialize, classLoader);
            if (forceLoader && c.getClassLoader() != classLoader) {
                ClassHelper.moveClassTo(c, classLoader);
            }
            return c;
        }
        catch (ClassNotFoundException ex) {
            TILRef.logError("Unable to find class with name `{}` using ClassLoader of type `{}`", name, classLoader.getClass().getName(), ex);
            return null;
        }
    }

    @Nullable
    @IndirectCallers
    public static Class<?>[] findClasses(String ... names) {
        return ArrayHelper.mapTo(names, Class.class, ClassHelper::findClass);
    }

    @Nullable
    @IndirectCallers
    public static Class<?>[] findClasses(ClassLoader classLoader, String ... names) {
        return ArrayHelper.mapTo(names, Class.class, name -> ClassHelper.findClass(name, classLoader));
    }

    @Nullable
    @IndirectCallers
    public static Class<?>[] findClasses(boolean initialize, String ... names) {
        return ArrayHelper.mapTo(names, Class.class, name -> ClassHelper.findClass(name, initialize));
    }

    @Nullable
    @IndirectCallers
    public static Class<?>[] findClasses(boolean initialize, ClassLoader classLoader, String ... names) {
        return ArrayHelper.mapTo(names, Class.class, name -> ClassHelper.findClass(name, initialize, classLoader, false));
    }

    @Nullable
    @IndirectCallers
    public static Class<?> findClassFrom(@Nullable Class<?> clazz, String simpleName) {
        return ClassHelper.findClassFrom(Objects.nonNull(clazz) ? clazz.getPackage() : null, simpleName);
    }

    @Nullable
    public static Class<?> findClassFrom(@Nullable Package pkg, String simpleName) {
        return ClassHelper.findClass(ClassHelper.withPkgName(pkg, simpleName));
    }

    @Nullable
    @IndirectCallers
    public static Class<?> findClassFrom(@Nullable Class<?> clazz, String simpleName, ClassLoader classLoader) {
        return ClassHelper.findClassFrom(Objects.nonNull(clazz) ? clazz.getPackage() : null, simpleName, classLoader);
    }

    @Nullable
    public static Class<?> findClassFrom(@Nullable Package pkg, String simpleName, ClassLoader classLoader) {
        return ClassHelper.findClass(ClassHelper.withPkgName(pkg, simpleName), classLoader);
    }

    @Nullable
    @IndirectCallers
    public static Class<?> findClassFrom(@Nullable Class<?> clazz, String simpleName, boolean initialize) {
        return ClassHelper.findClassFrom(Objects.nonNull(clazz) ? clazz.getPackage() : null, simpleName, initialize);
    }

    @Nullable
    public static Class<?> findClassFrom(@Nullable Package pkg, String simpleName, boolean initialize) {
        return ClassHelper.findClass(ClassHelper.withPkgName(pkg, simpleName), initialize);
    }

    @Nullable
    @IndirectCallers
    public static Class<?> findClassFrom(@Nullable Class<?> clazz, String simpleName, boolean initialize, ClassLoader classLoader) {
        return ClassHelper.findClassFrom(Objects.nonNull(clazz) ? clazz.getPackage() : null, simpleName, initialize, classLoader);
    }

    @Nullable
    public static Class<?> findClassFrom(@Nullable Package pkg, String simpleName, boolean initialize, ClassLoader classLoader) {
        return ClassHelper.findClass(ClassHelper.withPkgName(pkg, simpleName), initialize, classLoader, false);
    }

    public static byte[] getClassBytes(Class<?> clazz) {
        ClassHelper.checkBurningWaveInit();
        return BufferHandler.toByteArray(StaticComponentContainer.Classes.getByteCode(clazz));
    }

    public static URL getJarResource(String path, String relativePath) {
        try {
            String prefix = path.startsWith("/") ? "jar:file:" : "jar:file:/";
            return new URL(prefix + path + "!/" + relativePath);
        }
        catch (Exception ex) {
            TILRef.logError("Failed to get entry {} from presumed jar file {}", relativePath, path, ex);
            return null;
        }
    }

    public static String getResourcePath(String className) {
        return className.replace('.', '/') + ".class";
    }

    @Nullable
    public static URL getSourceURL(@Nullable String className, ClassLoader loader) {
        if (Objects.nonNull(className) && !className.isEmpty()) {
            try {
                String relativePath = ClassHelper.getResourcePath(className);
                return ClassHelper.absoluteLocation(loader.getResource(relativePath), relativePath);
            }
            catch (Exception ex) {
                TILRef.logError("Caught exception trying to get source URL for {} on {}", className, loader, ex);
            }
        } else {
            TILRef.logError("Cannot get source URL for null or empty class name!", new Object[0]);
        }
        return null;
    }

    @Nullable
    public static URL getSourceURL(@Nullable Class<?> clazz) {
        if (Objects.nonNull(clazz)) {
            ProtectionDomain pd = clazz.getProtectionDomain();
            if (Objects.nonNull(pd)) {
                CodeSource source = pd.getCodeSource();
                if (Objects.nonNull(source)) {
                    return source.getLocation();
                }
                TILRef.logError("Cannot get source URL for class with null CodeSource! {}", clazz);
            } else {
                TILRef.logError("Cannot get source URL for class with null ProtectionDomain! {}", clazz);
            }
        } else {
            TILRef.logError("Cannot get source URL for null class!", new Object[0]);
        }
        return null;
    }

    @Nullable
    @IndirectCallers
    public static String getSourceURLStr(@Nullable String className, ClassLoader loader) {
        if (Objects.nonNull(className) && !className.isEmpty()) {
            try {
                String relativePath = ClassHelper.getResourcePath(className);
                return ClassHelper.absoluteLocationStr(loader.getResource(relativePath), relativePath);
            }
            catch (Exception ex) {
                TILRef.logError("Caught exception trying to get source URL for {} on {}", className, loader, ex);
            }
        } else {
            TILRef.logError("Cannot get source URL for null or empty class name!", new Object[0]);
        }
        return null;
    }

    @Nullable
    public static <T> T initialize(@Nullable Class<T> clazz, Object ... args) {
        if (Objects.nonNull(clazz)) {
            try {
                ClassHelper.checkBurningWaveInit();
                return StaticComponentContainer.Constructors.newInstanceOf(clazz, args);
            }
            catch (Exception ex) {
                TILRef.logError("Failed to initialize {}", clazz, ex);
            }
        } else {
            TILRef.logError("Cannot initialize null class", new Object[0]);
        }
        return null;
    }

    @IndirectCallers
    public static String internalName(Class<?> clazz) {
        return ClassHelper.internalName(clazz.getName());
    }

    public static String internalName(String classpath) {
        return classpath.replace('.', '/');
    }

    @IndirectCallers
    public static void loadClass(String classpath, byte[] bytes) {
        ClassHelper.loadClass(ClassLoader.getSystemClassLoader(), classpath, bytes);
    }

    public static void loadClass(ClassLoader classLoader, String classpath, byte[] bytes) {
        ClassHelper.loadClass(classLoader, ClassHelper.defineClass(classLoader, classpath, bytes));
    }

    @IndirectCallers
    public static void loadClass(Class<?> clazz) {
        ClassHelper.loadClass(ClassLoader.getSystemClassLoader(), clazz);
    }

    public static void loadClass(ClassLoader classLoader, @Nullable Class<?> clazz) {
        if (Objects.nonNull(clazz)) {
            classLoader.loadClass(clazz.getName());
        } else {
            TILRef.logError("Tried to load null class to {}", classLoader);
        }
    }

    public static boolean loadURL(URLClassLoader classLoader, URL url) {
        TILDev.logDebug("Attempting to load URL `{}` with ClassLoader `{}`", url, classLoader);
        ReflectionHelper.invokeMethod(URLClassLoader.class, "addURL", (Object)classLoader, new Class[]{URL.class}, url);
        return true;
    }

    public static void moveClassTo(Class<?> c, ClassLoader target) {
        ClassLoader from = c.getClassLoader();
        if (from == target) {
            TILDev.logDebug("Not moving {} since it was already from {}", c, target);
            return;
        }
        StaticComponentContainer.Fields.set(c, "classLoader", (Object)target);
        ((Collection)StaticComponentContainer.Fields.get((Object)from, "classes")).remove(c);
        ((Collection)StaticComponentContainer.Fields.get((Object)target, "classes")).add(c);
    }

    @IndirectCallers
    public static String packageName(@Nullable Class<?> clazz) {
        return Objects.nonNull(clazz) ? clazz.getPackage().getName() : "";
    }

    public static Class<?> resolveClass(ClassLoader classLoader, @Nullable Class<?> clazz) {
        if (Objects.isNull(clazz)) {
            TILRef.logFatal("Cannot resolve null defined class! {}", new Object[0]);
            return null;
        }
        ClassHelper.checkBurningWaveInit();
        return StaticComponentContainer.ClassLoaders.loadOrDefine(clazz, classLoader);
    }

    @IndirectCallers
    public static String signature(Class<?> clazz, Class<?> ... parameters) {
        return ClassHelper.signatureDesc(ClassHelper.descriptor(clazz), ArrayHelper.mapTo(parameters, String.class, ClassHelper::descriptor));
    }

    @IndirectCallers
    public static String signatureClasspath(String classpath, String ... parameterPaths) {
        return ClassHelper.signatureDesc(ClassHelper.descriptor(classpath), ArrayHelper.mapTo(parameterPaths, String.class, ClassHelper::descriptor));
    }

    public static String signatureDesc(String desc, String ... parameterDescs) {
        if (TextHelper.isBlank(desc)) {
            return "";
        }
        StringBuilder builder = new StringBuilder(desc.substring(0, desc.length() - 1)).append("<");
        if (ArrayHelper.isNotEmpty(parameterDescs)) {
            for (String parameter : parameterDescs) {
                builder.append(parameter);
            }
        }
        return builder.append(">;").toString();
    }

    @IndirectCallers
    public static String signatureInternal(String name, String ... parameterNames) {
        if (TextHelper.isBlank(name)) {
            return "";
        }
        return ClassHelper.signatureDesc("L" + name + ";", ArrayHelper.mapTo(parameterNames, String.class, p -> "L" + p + ";"));
    }

    @IndirectCallers
    public static void syncSourcesAndLoadClass(ClassLoader syncFrom, ClassLoader syncTo, String className, BiFunction<ClassLoader, URL, Boolean> urlLoader) {
        ClassHelper.syncSourcesForClass(syncFrom, syncTo, className, urlLoader, className);
    }

    public static Class<?> syncDirect(ClassLoader loader, Class<?> clazz) {
        TILDev.logInfo("Attempting direct sync of {} to {}", clazz, loader);
        if (loader == clazz.getClassLoader()) {
            TILRef.logError("Tried to sync {} to its own loader", clazz);
            return clazz;
        }
        return ClassHelper.resolveClass(loader, ClassHelper.defineClass(loader, clazz.getName(), ClassHelper.getClassBytes(clazz)));
    }

    public static void syncSourcesForClass(ClassLoader syncFrom, ClassLoader syncTo, String className, BiFunction<ClassLoader, URL, Boolean> urlLoader, String ... classesToLoad) {
        try {
            TILRef.logDebug("Attempting to sync class loaders for {} ({} -> {})", className, syncFrom, syncTo);
            URL url = ClassHelper.getSourceURL(syncFrom.loadClass(className));
            if (Objects.nonNull(url)) {
                TILRef.logDebug("Syncing URL {}", url);
                if (!urlLoader.apply(syncTo, url).booleanValue()) {
                    TILRef.logError("Failed to sync sources for {} from {} to {}!", className, syncFrom, syncTo);
                } else if (Objects.nonNull(classesToLoad)) {
                    for (String classToLoad : classesToLoad) {
                        ClassHelper.findClass(classToLoad, syncTo);
                    }
                }
            } else {
                TILRef.logDebug("Not syncing null URL", new Object[0]);
            }
        }
        catch (ClassNotFoundException ex) {
            ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
            if (Misc.equalsAny(systemLoader, syncFrom, syncTo)) {
                TILRef.logError("Failed to sync sources for {} from {} to {}!", className, syncFrom, syncTo, ex);
            }
            ClassHelper.syncSourcesForClass(systemLoader, syncTo, className, urlLoader, classesToLoad);
        }
    }

    @IndirectCallers
    public static String withPkgName(@Nullable Class<?> ref, String simpleName) {
        return ClassHelper.withPkgName(Objects.nonNull(ref) ? ref.getPackage() : null, simpleName);
    }

    public static String withPkgName(@Nullable Package pkg, String simpleName) {
        simpleName = Objects.nonNull(simpleName) ? simpleName.replace(" ", "").replace('/', '.') : null;
        return Objects.nonNull(pkg) && TextHelper.isNotBlank(pkg.getName()) ? pkg.getName() + "." + simpleName : simpleName;
    }
}

