/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget;

import java.util.Collection;
import java.util.Collections;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Widget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.WidgetGroup;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.GLAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderScale;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Box;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.ShapeHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.VectorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextAPI;

public abstract class BoundedWidgetGroup
extends WidgetGroup {
    @Override
    public abstract BoundedWidgetGroup copy();

    @Override
    public void drawWidget(RenderContext ctx, Widget widget, Vector3 center, double mouseX, double mouseY) {
        RenderScale scale = ctx.getScale();
        Box previousBounds = scale.getRenderBounds();
        Box bounds = this.getRenderBounds(center);
        scale.setRenderBounds(bounds);
        GLAPI gl = ctx.getRenderer().getGLAPI();
        int scissorTest = gl.scissorTest();
        gl.enable(scissorTest);
        ctx.scissorScaled(this.getLeft(), -this.getBottom(), bounds.getWidth(), bounds.getHeight() + 1.0);
        super.drawWidget(ctx, widget, center, mouseX, mouseY);
        gl.disable(scissorTest);
        scale.setRenderBounds(previousBounds);
    }

    @Override
    public Collection<TextAPI<?>> getHoverLines(double mouseX, double mouseY) {
        return this.isBounded(mouseX, mouseY) ? super.getHoverLines(mouseX, mouseY) : Collections.emptyList();
    }

    protected Box getRenderBounds(Vector3 center) {
        return ShapeHelper.box(this.getCenter(center), this.getWidth(), this.getHeight());
    }

    protected Box getRenderBounds(Vector3 center, Vector3 offset) {
        return this.getRenderBounds(center, offset.dX(), offset.dY(), offset.dZ());
    }

    protected Box getRenderBounds(Vector3 center, double offsetX, double offsetY, double offsetZ) {
        return ShapeHelper.box(this.getCenter(center).add(offsetX, offsetY, offsetZ), this.getWidth(), this.getHeight());
    }

    public boolean isBounded(double x, double y) {
        return this.isBounded(VectorHelper.zero3D(), x, y);
    }

    public boolean isBounded(Vector3 center, double x, double y) {
        return this.getRenderBounds(center).isInsideXY(x, y);
    }

    public boolean isBounded(Vector3 center, Vector3 pos) {
        return this.getRenderBounds(center).isInside(pos);
    }

    @Override
    public boolean onLeftClick(double mouseX, double mouseY) {
        return this.isBounded(mouseX, mouseY) && super.onLeftClick(mouseX, mouseY);
    }

    @Override
    public boolean onRightClick(double mouseX, double mouseY) {
        return this.isBounded(mouseX, mouseY) && super.onRightClick(mouseX, mouseY);
    }
}

