/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.geometry;

import mods.thecomputerizer.theimpossiblelibrary.api.client.geometry.Convex3D;
import mods.thecomputerizer.theimpossiblelibrary.api.client.geometry.ShapeHolder;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;

public class Tesseract
extends ShapeHolder {
    private final Convex3D innerShape;
    private Vector3 maxScale = new Vector3(1.0, 1.0, 1.0);
    private int scaleCounter;
    private boolean counterReversal = false;

    public Tesseract(Convex3D shape) {
        super(shape);
        this.innerShape = new Convex3D(shape);
    }

    @Override
    public ShapeHolder setRotations(double x, double y, double z) {
        this.shape.setRotationSpeed(x, y, z);
        this.innerShape.setRotationSpeed(x, y, z);
        return this;
    }

    @Override
    public ShapeHolder setScale(float x, float y, float z) {
        this.maxScale = new Vector3(Float.valueOf(x), Float.valueOf(y), Float.valueOf(z));
        this.shape.setScale(x, y, z);
        this.innerShape.setScale(x / 2.0f, y / 2.0f, z / 2.0f);
        return this;
    }

    @Override
    public ShapeHolder setColor(float ... colors) {
        this.shape.setColor(colors);
        this.innerShape.setColor(colors);
        return this;
    }

    @Override
    public void render(RenderContext ctx, Vector3 relativeCenter) {
        if (this.scaleCounter >= 200) {
            this.counterReversal = true;
        } else if (this.scaleCounter < 0) {
            this.counterReversal = false;
        }
        this.scaleCounter = this.counterReversal ? --this.scaleCounter : ++this.scaleCounter;
        super.render(ctx, relativeCenter);
        this.innerShape.render(ctx, relativeCenter.add(this.relativePosVec));
    }

    @Override
    public void renderScaledRelative(RenderContext ctx, Vector3 relativeCenter, float s) {
        if (this.scaleCounter >= 200) {
            this.counterReversal = true;
        } else if (this.scaleCounter < 0) {
            this.counterReversal = false;
        }
        this.scaleCounter = this.counterReversal ? --this.scaleCounter : ++this.scaleCounter;
        super.renderScaledRelative(ctx, relativeCenter, s);
        this.innerShape.render(ctx, relativeCenter.add(this.relativePosVec.mulScalar(Float.valueOf(s))));
    }

    private float getScale(float scale, float factor) {
        return scale - scale / 2.0f * factor;
    }
}

