/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.configs.BzWorldgenConfigs;
import com.telepathicgrunt.the_bumblezone.mixin.world.WorldGenRegionAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.worldgen.features.NbtFeature;
import com.telepathicgrunt.the_bumblezone.worldgen.features.configs.TreeDungeonFeatureConfig;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class TreeDungeon
extends NbtFeature<TreeDungeonFeatureConfig> {
    public TreeDungeon(Codec<TreeDungeonFeatureConfig> configFactory) {
        super(configFactory);
    }

    @Override
    public boolean m_142674_(FeaturePlaceContext<TreeDungeonFeatureConfig> context) {
        if (BzWorldgenConfigs.treeDungeonRarity >= 1000 || context.m_225041_().m_188503_(BzWorldgenConfigs.treeDungeonRarity) != 0) {
            return false;
        }
        if (TreeDungeon.isValidDungeonSpot(context)) {
            super.m_142674_(context);
            WorldGenLevel level = context.m_159774_();
            BlockPos center = context.m_159777_().m_6630_(((TreeDungeonFeatureConfig)context.m_159778_()).structureYOffset + 3);
            level.m_7731_(center, Blocks.f_50627_.m_49966_(), 3);
            level.m_7731_(center.m_7494_(), Blocks.f_50627_.m_49966_(), 3);
            Optional configuredFeature = level.m_9598_().m_175515_(Registries.f_256911_).m_6612_(((TreeDungeonFeatureConfig)context.m_159778_()).treeConfiguredFeature);
            configuredFeature.ifPresent(cf -> cf.m_224953_(level, context.m_159775_(), context.m_225041_(), center));
        }
        return true;
    }

    protected static boolean isValidDungeonSpot(FeaturePlaceContext<?> context) {
        Registry configuredStructureFeatureRegistry = (Registry)context.m_159774_().m_9598_().m_6632_(Registries.f_256944_).get();
        if (context.m_159774_() instanceof WorldGenRegion) {
            StructureManager structureManager = ((WorldGenRegionAccessor)context.m_159774_()).bumblezone$getStructureManager();
            for (Object configuredStructureFeature : configuredStructureFeatureRegistry.m_206058_(BzTags.NO_DUNGEONS)) {
                StructureStart startForFeature = structureManager.m_220494_(context.m_159777_(), (Structure)configuredStructureFeature.m_203334_());
                if (!startForFeature.m_73603_()) continue;
                return false;
            }
        }
        if (!context.m_159774_().m_8055_(context.m_159777_()).m_60815_()) {
            return false;
        }
        boolean validSpot = false;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        mutable.m_122190_((Vec3i)context.m_159777_());
        for (Direction face : Direction.Plane.HORIZONTAL) {
            mutable.m_122190_((Vec3i)context.m_159777_()).m_122175_(face, 3);
            BlockState state = context.m_159774_().m_8055_((BlockPos)mutable);
            if (!state.m_60713_(Blocks.f_50627_) && !state.m_60713_(BzBlocks.PILE_OF_POLLEN.get())) continue;
            validSpot = true;
            break;
        }
        for (int xOffset = -6; xOffset <= 6; xOffset += 6) {
            for (int zOffset = -6; zOffset <= 6; zOffset += 6) {
                for (int yOffset = -3; yOffset <= 9; yOffset += 3) {
                    mutable.m_122190_((Vec3i)context.m_159777_()).m_122184_(xOffset, yOffset, zOffset);
                    if (!context.m_159774_().m_8055_((BlockPos)mutable).m_60713_(Blocks.f_50016_)) continue;
                    validSpot = false;
                }
            }
        }
        return validSpot;
    }
}

