/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modules;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.configs.BzDimensionConfigs;
import com.telepathicgrunt.the_bumblezone.modules.base.Module;
import com.telepathicgrunt.the_bumblezone.modules.base.ModuleSerializer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;

public class EntityPosAndDimModule
implements Module<EntityPosAndDimModule> {
    public static final ModuleSerializer<EntityPosAndDimModule> SERIALIZER = new Serializer();
    private ResourceLocation nonBZDimension = new ResourceLocation(BzDimensionConfigs.defaultDimension);
    private Vec3 nonBZPosition = null;

    public void setNonBZDim(ResourceLocation incomingDim) {
        if (incomingDim.equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
            this.nonBZDimension = new ResourceLocation(BzDimensionConfigs.defaultDimension);
            Bumblezone.LOGGER.error("Error: The non-bz dimension passed in to be stored was bz dimension. Please contact mod creator to let them know of this issue.");
        } else {
            this.nonBZDimension = incomingDim;
        }
    }

    public ResourceLocation getNonBZDim() {
        return this.nonBZDimension;
    }

    public void setNonBZPos(Vec3 incomingPos) {
        this.nonBZPosition = incomingPos;
    }

    public Vec3 getNonBZPos() {
        return this.nonBZPosition;
    }

    public boolean hasPos() {
        return this.nonBZPosition != null;
    }

    @Override
    public ModuleSerializer<EntityPosAndDimModule> serializer() {
        return SERIALIZER;
    }

    private static final class Serializer
    implements ModuleSerializer<EntityPosAndDimModule> {
        private Serializer() {
        }

        @Override
        public Class<EntityPosAndDimModule> moduleClass() {
            return EntityPosAndDimModule.class;
        }

        @Override
        public ResourceLocation id() {
            return new ResourceLocation("the_bumblezone", "entity_dim_component");
        }

        @Override
        public void read(EntityPosAndDimModule module, CompoundTag tag) {
            module.setNonBZDim(new ResourceLocation(tag.m_128461_("non_bz_dimensiontype_namespace"), tag.m_128461_("non_bz_dmensiontype_path")));
            if (tag.m_128441_("non_bz_position_x") && tag.m_128441_("non_bz_position_y") && tag.m_128441_("non_bz_position_z")) {
                module.setNonBZPos(new Vec3(tag.m_128459_("non_bz_position_x"), tag.m_128459_("non_bz_position_y"), tag.m_128459_("non_bz_position_z")));
            } else {
                module.setNonBZPos(null);
            }
        }

        @Override
        public void write(CompoundTag tag, EntityPosAndDimModule module) {
            tag.m_128359_("non_bz_dimensiontype_namespace", module.getNonBZDim().m_135827_());
            tag.m_128359_("non_bz_dmensiontype_path", module.getNonBZDim().m_135815_());
            if (module.getNonBZPos() != null) {
                tag.m_128347_("non_bz_position_x", module.getNonBZPos().m_7096_());
                tag.m_128347_("non_bz_position_y", module.getNonBZPos().m_7098_());
                tag.m_128347_("non_bz_position_z", module.getNonBZPos().m_7094_());
            }
        }

        @Override
        public void onPlayerCopy(EntityPosAndDimModule oldModule, EntityPosAndDimModule thisModule, ServerPlayer player, boolean isPersistent) {
            ModuleSerializer.super.onPlayerCopy(oldModule, thisModule, player, true);
        }
    }
}

