/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.telepathicgrunt.the_bumblezone.entities.teleportation.BzWorldSavedData;
import com.telepathicgrunt.the_bumblezone.entities.teleportation.EntityTeleportationHookup;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzDimension;
import com.telepathicgrunt.the_bumblezone.modinit.BzEnchantments;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class BumblezoneAPI {
    public static final ResourceLocation MOD_DIMENSION_ID = new ResourceLocation("the_bumblezone", "the_bumblezone");

    public static void teleportOutOfBz(LivingEntity livingEntity) {
        EntityTeleportationHookup.teleportOutOfBz(livingEntity);
    }

    public static boolean runEnderpearlImpact(HitResult hitResult, Entity thrower, Projectile projectile) {
        return EntityTeleportationHookup.runTeleportProjectileImpact(hitResult, thrower, (Entity)projectile);
    }

    public static boolean runEnderpearlImpact(HitResult hitResult, @NotNull Projectile projectile) {
        return EntityTeleportationHookup.runTeleportProjectileImpact(hitResult, projectile.m_19749_(), (Entity)projectile);
    }

    public static boolean runItemUseOn(Player user, BlockPos clickedPos, ItemStack usingStack) {
        return EntityTeleportationHookup.runItemUseOn(user, clickedPos, usingStack);
    }

    public static boolean runGenericTeleport(Player user, BlockPos targetPos) {
        return EntityTeleportationHookup.runGenericTeleport(user, targetPos);
    }

    public static void runPistonPushed(Direction direction, LivingEntity livingEntity) {
        EntityTeleportationHookup.runPistonPushed(direction, livingEntity);
    }

    public static void triggerEnderPearlAdvancement(ServerPlayer serverPlayer) {
        BzCriterias.TELEPORT_TO_BUMBLEZONE_PEARL_TRIGGER.trigger(serverPlayer);
    }

    public static void triggerPistonAdvancement(ServerPlayer serverPlayer) {
        BzCriterias.TELEPORT_TO_BUMBLEZONE_PISTON_TRIGGER.trigger(serverPlayer);
    }

    public static void triggerExitingBumblezoneAdvancement(ServerPlayer serverPlayer) {
        BzCriterias.TELEPORT_OUT_OF_BUMBLEZONE_TRIGGER.trigger(serverPlayer);
    }

    public static void queueEntityForTeleportingToBumblezone(Entity entity) {
        BzWorldSavedData.queueEntityToTeleport(entity, BzDimension.BZ_WORLD_KEY);
    }

    public static void queueEntityForTeleportingOutOfBumblezone(Entity entity, ResourceKey<Level> worldToTeleportTo) {
        BzWorldSavedData.queueEntityToTeleport(entity, worldToTeleportTo);
    }

    public static boolean playerHasBeeEssence(ServerPlayer serverPlayer) {
        return EssenceOfTheBees.hasEssence(serverPlayer);
    }

    public static void triggerCombCutterExtraDropAdvancement(ServerPlayer serverPlayer) {
        BzCriterias.COMB_CUTTER_EXTRA_DROPS_TRIGGER.trigger(serverPlayer);
    }

    public static int getCombCutterLevelForItem(ItemStack toolUsed) {
        return EnchantmentHelper.m_44843_((Enchantment)BzEnchantments.COMB_CUTTER.get(), (ItemStack)toolUsed);
    }

    public static int getCombCutterLevelForItem(ServerPlayer serverPlayer) {
        return EnchantmentHelper.m_44836_((Enchantment)BzEnchantments.COMB_CUTTER.get(), (LivingEntity)serverPlayer);
    }
}

