/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.blocks.blockentities.PotionCandleBlockEntity;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class PotionCandleBlockItem
extends BlockItem {
    public PotionCandleBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    protected boolean m_7274_(BlockPos pos, Level level, Player player, ItemStack stack, BlockState state) {
        BlockEntity blockEntity;
        if (level.m_5776_() && stack.m_41782_() && (blockEntity = level.m_7702_(pos)) instanceof PotionCandleBlockEntity) {
            PotionCandleBlockEntity potionCandleBlockEntity = (PotionCandleBlockEntity)blockEntity;
            CompoundTag blockEntityTag = stack.m_41784_().m_128469_("BlockEntityTag");
            int color = blockEntityTag.m_128441_("color") ? blockEntityTag.m_128451_("color") : 0xFFFFFF;
            potionCandleBlockEntity.setColor(color);
            ResourceLocation rl = new ResourceLocation(blockEntityTag.m_128461_("status"));
            Optional mobEffect = BuiltInRegistries.f_256974_.m_6612_(rl);
            potionCandleBlockEntity.setMobEffect(mobEffect.orElse(null));
        }
        return super.m_7274_(pos, level, player, stack, state);
    }

    public String m_5524_() {
        return this.m_41467_();
    }

    public void m_7373_(ItemStack itemStack, Level level, List<Component> components, TooltipFlag tooltipFlag) {
        ResourceLocation rl;
        Optional mobEffect;
        CompoundTag blockEntityTag;
        if (itemStack.m_41782_() && (blockEntityTag = itemStack.m_41784_().m_128469_("BlockEntityTag")).m_128441_("status") && (mobEffect = BuiltInRegistries.f_256974_.m_6612_(rl = new ResourceLocation(blockEntityTag.m_128461_("status")))).isPresent()) {
            int lingerTime;
            components.add((Component)PotionCandleBlockItem.formatComponent(Component.m_237110_((String)"item.the_bumblezone.potion_candle.status_effect", (Object[])new Object[]{((MobEffect)mobEffect.get()).m_19482_()})));
            components.add((Component)PotionCandleBlockItem.formatComponent(Component.m_237110_((String)"item.the_bumblezone.potion_candle.amplifier", (Object[])new Object[]{blockEntityTag.m_128451_("amplifier")})));
            components.add((Component)PotionCandleBlockItem.formatComponent(Component.m_237110_((String)"item.the_bumblezone.potion_candle.range", (Object[])new Object[]{blockEntityTag.m_128451_("range")})));
            if (blockEntityTag.m_128441_("infinite") && blockEntityTag.m_128471_("infinite")) {
                components.add((Component)PotionCandleBlockItem.formatComponent(Component.m_237110_((String)"item.the_bumblezone.potion_candle.max_duration", (Object[])new Object[]{Component.m_237115_((String)"item.the_bumblezone.potion_candle.infinite")})));
            } else if (blockEntityTag.m_128441_("max_duration")) {
                components.add((Component)PotionCandleBlockItem.formatComponent(Component.m_237110_((String)"item.the_bumblezone.potion_candle.max_duration", (Object[])new Object[]{PotionCandleBlockItem.formatTime(blockEntityTag.m_128451_("max_duration"))})));
            } else {
                components.add((Component)PotionCandleBlockItem.formatComponent(Component.m_237110_((String)"item.the_bumblezone.potion_candle.max_duration", (Object[])new Object[]{PotionCandleBlockItem.formatTime(12000L)})));
            }
            if (((MobEffect)mobEffect.get()).m_8093_()) {
                components.add((Component)PotionCandleBlockItem.formatComponent(Component.m_237110_((String)"item.the_bumblezone.potion_candle.apply_interval", (Object[])new Object[]{PotionCandleBlockItem.formatTime(PotionCandleBlockEntity.getInstantEffectThresholdTime(blockEntityTag.m_128451_("amplifier")))})));
            }
            if ((lingerTime = blockEntityTag.m_128451_("linger_time")) > 20) {
                components.add((Component)PotionCandleBlockItem.formatComponent(Component.m_237110_((String)"item.the_bumblezone.potion_candle.lingering_time", (Object[])new Object[]{PotionCandleBlockItem.formatTime(lingerTime)})));
            }
        }
    }

    private static MutableComponent formatComponent(MutableComponent component) {
        return component.m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY);
    }

    private static String formatTime(long duration) {
        long totalSeconds = duration / 20L;
        long minutes = totalSeconds / 60L;
        long seconds = totalSeconds % 60L;
        return String.format("%d:%02d", minutes, seconds);
    }
}

