/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.configs.forge;

import com.telepathicgrunt.the_bumblezone.configs.BzDimensionConfigs;
import net.minecraftforge.common.ForgeConfigSpec;

public class BzDimensionConfig {
    public static final ForgeConfigSpec GENERAL_SPEC;
    public static ForgeConfigSpec.BooleanValue enableInitialWelcomeMessage;
    public static ForgeConfigSpec.BooleanValue forceExitToOverworld;
    public static ForgeConfigSpec.BooleanValue onlyOverworldHivesTeleports;
    public static ForgeConfigSpec.BooleanValue warnPlayersOfWrongBlockUnderHive;
    public static ForgeConfigSpec.BooleanValue allowTeleportationWithModdedBeehives;
    public static ForgeConfigSpec.BooleanValue enableExitTeleportation;
    public static ForgeConfigSpec.BooleanValue enableEntranceTeleportation;
    public static ForgeConfigSpec.BooleanValue forceBumblezoneOriginMobToOverworldCenter;
    public static ForgeConfigSpec.ConfigValue<String> defaultDimension;

    private static void setupConfig(ForgeConfigSpec.Builder builder) {
        builder.push("The Bumblezone Welcome Options");
        enableInitialWelcomeMessage = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Whether to show message saying to check out Bumblezone's advancements when you get enar beehive for first time.\n"}).translation("the_bumblezone.config.enableinitialwelcomemessage").define("enableInitialWelcomeMessage", true);
        builder.pop();
        builder.push("The Bumblezone Teleportation Options");
        enableEntranceTeleportation = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Allow Bumblezone mod to handle teleporting into the Bumblezone dimension.\n"}).translation("the_bumblezone.config.enableentranceteleportation").define("enableEntranceTeleportation", true);
        enableExitTeleportation = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Allow Bumblezone mod to handle teleporting out of the Bumblezone dimension.\n"}).translation("the_bumblezone.config.enableexitteleportation").define("enableExitTeleportation", true);
        forceBumblezoneOriginMobToOverworldCenter = builder.comment(new String[]{" \n-----------------------------------------------------\n", " If this is enabled, mobs that originally spawned in Bumblezone will be teleported", " to 0, 0 center of the Overworld when exiting Bumblezone dimension.\n"}).translation("the_bumblezone.config.forcebumblezoneoriginmobtooverworldcenter").define("forceBumblezoneOriginMobToOverworldCenter", true);
        forceExitToOverworld = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Makes leaving The Bumblezone dimension always places you back", " at the Overworld regardless of which dimension you originally ", " came from. Use this option if this dimension becomes locked in  ", " with another dimension so you are stuck teleporting between the ", " two and cannot get back to the Overworld.\n"}).translation("the_bumblezone.config.forceexittooverworld").define("forceExitToOverworld", false);
        onlyOverworldHivesTeleports = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Makes throwing Enderpearls at Bee Nests or Hives only ", " work in the Overworld. What this means setting this to true makes it ", " only possible to enter The Bumblezone dimension from the Overworld"}).translation("the_bumblezone.config.onlyoverworldhivesteleports").define("onlyOverworldHivesTeleports", false);
        warnPlayersOfWrongBlockUnderHive = builder.comment(new String[]{" \n-----------------------------------------------------\n", " If the block tag the_bumblezone:dimension_teleportation/required_blocks_under_beehive_to_teleport", " has blocks specified and this config is set to true, then player will get a warning if they", " throw an Enderpearl at a Bee Nest/Beehive but the block under it is ", " not the correct required block. It will also tell the player what ", " block is needed under the Bee Nest/Beehive to teleport to the dimension.\n"}).translation("the_bumblezone.config.warnplayersofwrongblockunderhive").define("warnPlayersOfWrongBlockUnderHive", true);
        allowTeleportationWithModdedBeehives = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Should teleporting to and from The Bumblezone work ", " with modded Bee Nests and modded Beehives as well. \n"}).translation("the_bumblezone.config.allowteleportationwithmoddedbeehives").define("allowTeleportationWithModdedBeehives", true);
        defaultDimension = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Changes the default dimension that teleporting exiting will take mobs to ", " if there is no previously saved dimension on the mob. ", " Use this option ONLY if your modpack's default dimension is not the Overworld. ", " This will affect forceExitToOverworld, forceBumblezoneOriginMobToOverworldCenter, and onlyOverworldHivesTeleports", " config options so that they use this new default dimension instead of Overworld.\n"}).translation("the_bumblezone.config.defaultdimension").define("defaultDimension", (Object)"minecraft:overworld");
        builder.pop();
    }

    public static void copyToCommon() {
        BzDimensionConfigs.enableInitialWelcomeMessage = (Boolean)enableInitialWelcomeMessage.get();
        BzDimensionConfigs.enableEntranceTeleportation = (Boolean)enableEntranceTeleportation.get();
        BzDimensionConfigs.enableExitTeleportation = (Boolean)enableExitTeleportation.get();
        BzDimensionConfigs.forceBumblezoneOriginMobToOverworldCenter = (Boolean)forceBumblezoneOriginMobToOverworldCenter.get();
        BzDimensionConfigs.forceExitToOverworld = (Boolean)forceExitToOverworld.get();
        BzDimensionConfigs.onlyOverworldHivesTeleports = (Boolean)onlyOverworldHivesTeleports.get();
        BzDimensionConfigs.warnPlayersOfWrongBlockUnderHive = (Boolean)warnPlayersOfWrongBlockUnderHive.get();
        BzDimensionConfigs.allowTeleportationWithModdedBeehives = (Boolean)allowTeleportationWithModdedBeehives.get();
        BzDimensionConfigs.defaultDimension = (String)defaultDimension.get();
    }

    static {
        ForgeConfigSpec.Builder configBuilder = new ForgeConfigSpec.Builder();
        BzDimensionConfig.setupConfig(configBuilder);
        GENERAL_SPEC = configBuilder.build();
    }
}

