/*
 * Decompiled with CFR 0.152.
 */
package moonfather.tetra_tables.blocks;

import java.util.List;
import moonfather.tetra_tables.blocks.TetraTableBlockEntity;
import moonfather.tetra_tables.initialization.Registration;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.workbench.AbstractWorkbenchBlock;
import se.mickelus.tetra.blocks.workbench.WorkbenchTile;

public class TetraTable
extends AbstractWorkbenchBlock {
    private static final VoxelShape SHAPE_TOP = Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_LEG1 = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)12.0, (double)16.0);
    private static final VoxelShape SHAPE_LEG2 = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)3.0);
    private static final VoxelShape SHAPE_LEG3 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)12.0, (double)3.0);
    private static final VoxelShape SHAPE_LEG4 = Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)12.0, (double)16.0);
    private static final VoxelShape SHAPE_TABLE = Shapes.m_83124_((VoxelShape)SHAPE_TOP, (VoxelShape[])new VoxelShape[]{SHAPE_LEG1, SHAPE_LEG2, SHAPE_LEG3, SHAPE_LEG4});
    private final Component MessageInaccessible = Component.m_237115_((String)"message.tetra_tables.table_obscured");
    private final Component hoverText = Component.m_237115_((String)"block.tetra.basic_workbench.description").m_130940_(ChatFormatting.GRAY);

    public TetraTable(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public TetraTable() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_278166_(PushReaction.DESTROY));
    }

    public VoxelShape m_7952_(BlockState p_60578_, BlockGetter p_60579_, BlockPos p_60580_) {
        return SHAPE_TABLE;
    }

    public VoxelShape m_7947_(BlockState p_60581_, BlockGetter p_60582_, BlockPos p_60583_) {
        return SHAPE_TABLE;
    }

    public VoxelShape m_5940_(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return SHAPE_TABLE;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 5;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 20;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (this.isObscured(level, pos)) {
            if (level.f_46443_) {
                player.m_5661_(this.MessageInaccessible, true);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        InteractionResult interactionResult = BlockInteraction.attemptInteraction((Level)level, (BlockState)state, (BlockPos)pos, (Player)player, (InteractionHand)hand, (BlockHitResult)blockHitResult);
        if (interactionResult != InteractionResult.PASS || hand == InteractionHand.OFF_HAND) {
            return interactionResult;
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity te = level.m_7702_(pos);
        if (te instanceof TetraTableBlockEntity) {
            TetraTableBlockEntity ttbe = (TetraTableBlockEntity)te;
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)ttbe, (BlockPos)pos);
        }
        return InteractionResult.CONSUME;
    }

    private boolean isObscured(Level level, BlockPos pos) {
        if (!level.m_6425_(pos.m_7494_()).m_76152_().equals(Fluids.f_76191_)) {
            return true;
        }
        VoxelShape s = level.m_8055_(pos.m_7494_()).m_60655_((BlockGetter)level, pos.m_7494_(), Direction.DOWN);
        if (s.m_83281_()) {
            return false;
        }
        double area = (s.m_83297_(Direction.Axis.X) - s.m_83288_(Direction.Axis.X)) * (s.m_83297_(Direction.Axis.Z) - s.m_83288_(Direction.Axis.Z));
        double lesserDim = Math.min(s.m_83297_(Direction.Axis.X) - s.m_83288_(Direction.Axis.X), s.m_83297_(Direction.Axis.Z) - s.m_83288_(Direction.Axis.Z));
        return area > 0.1875 || lesserDim > 0.1875;
    }

    public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockGetter, List<Component> list, TooltipFlag tooltipFlag) {
        list.add(this.hoverText);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity te;
        if (!((Object)((Object)this)).equals(newState.m_60734_()) && (te = worldIn.m_7702_(pos)) instanceof WorkbenchTile) {
            LazyOptional oih = te.getCapability(ForgeCapabilities.ITEM_HANDLER);
            oih.ifPresent(ih -> {
                for (int i = 0; i < ih.getSlots(); ++i) {
                    ItemStack itemStack = ih.getStackInSlot(i);
                    if (itemStack.m_41619_()) continue;
                    Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)itemStack.m_41777_());
                }
            });
            te.m_7651_();
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState blockState) {
        return ((BlockEntityType)Registration.TETRA_TABLE_BE.get()).m_155264_(pos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_153212_, BlockState p_153213_, BlockEntityType<T> p_153214_) {
        return null;
    }
}

