/*
 * Decompiled with CFR 0.152.
 */
package moonfather.tetra_tables;

import net.minecraft.advancements.Advancement;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import se.mickelus.tetra.TetraToolActions;

public class HammerEvent {
    private static final ResourceLocation WORKBENCH_ADVANCEMENT = new ResourceLocation("tetra", "upgrades/workbench");
    private static final TagKey<Block> workbench = BlockTags.create((ResourceLocation)new ResourceLocation("forge", "workbench"));
    private static final Component tableNotFound1 = Component.m_237115_((String)"message.tetra_tables.tableNotFound1");
    private static final Component tableNotFound2 = Component.m_237115_((String)"message.tetra_tables.tableNotFound2");

    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockState state = event.getLevel().m_8055_(event.getPos());
        if (state.m_204336_(workbench) && !event.getEntity().m_6047_() && !state.m_60713_(Blocks.f_50091_) && event.getHand().equals((Object)InteractionHand.MAIN_HAND) && event.getEntity().m_21205_().canPerformAction(TetraToolActions.hammer)) {
            Block newTable = HammerEvent.tryGetTable(state.m_60734_());
            if (newTable != null) {
                event.getLevel().m_46597_(event.getPos(), newTable.m_49966_());
                event.getLevel().m_5594_(event.getEntity(), event.getPos(), SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 0.5f);
                Player player = event.getEntity();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    Advancement a = serverPlayer.m_20194_().m_129889_().m_136041_(WORKBENCH_ADVANCEMENT);
                    serverPlayer.m_8960_().m_135988_(a, "hammer");
                }
            } else if (event.getLevel().f_46443_) {
                if (ModList.get().isLoaded("workshop_for_handsome_adventurer")) {
                    event.getEntity().m_5661_(tableNotFound2, true);
                } else {
                    event.getEntity().m_5661_(tableNotFound1, true);
                }
            }
            event.setResult(Event.Result.DENY);
            event.setUseItem(Event.Result.DENY);
            event.setUseBlock(Event.Result.DENY);
        }
    }

    private static Block tryGetTable(Block block) {
        String id = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        String wood = null;
        int namePos = id.indexOf("simple_table_");
        if (namePos >= 0) {
            wood = id.substring(namePos + 13);
        }
        if (wood == null && (namePos = id.indexOf("_crafting_table")) >= 0) {
            wood = id.substring(0, namePos);
        }
        if (wood == null && id.startsWith("crafting_table_")) {
            wood = id.substring(15);
        }
        if (wood == null) {
            return null;
        }
        ResourceLocation rl = new ResourceLocation("tetra_tables", "tetra_table_" + wood);
        if (ForgeRegistries.BLOCKS.containsKey(rl)) {
            return (Block)ForgeRegistries.BLOCKS.getValue(rl);
        }
        return null;
    }
}

