/*
 * Decompiled with CFR 0.152.
 */
package com.tetra_loopback.item.modular;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.gui.GuiModuleOffsets;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public abstract class ModularEmblem
extends ModularItem
implements ICurio {
    public static final String emblemBase = "emblem/base";
    public static final String emblemPattern = "emblem/pattern";
    public static final String emblemCarving = "emblem/carving";
    public static final String identifier = "modular_emblem";
    private static final GuiModuleOffsets majorOffsets = new GuiModuleOffsets(new int[]{4, 20, -12, 20});
    private static final GuiModuleOffsets minorOffsets = new GuiModuleOffsets(new int[]{-13, -1});
    @ObjectHolder(registryName="item", value="tetra:modular_emblem")
    public static ModularEmblem instance;

    public ModularEmblem() {
        super(new Item.Properties().m_41487_(1).m_41486_());
        this.canHone = false;
        this.majorModuleKeys = new String[]{emblemBase, emblemPattern};
        this.minorModuleKeys = new String[]{emblemCarving};
        this.requiredModules = new String[]{emblemBase, emblemPattern};
    }

    public Collection<ItemModule> getAllModules(ItemStack stack) {
        CompoundTag stackTag = stack.m_41783_();
        if (stackTag != null) {
            return Stream.concat(Arrays.stream(this.getMajorModuleKeys(stack)), Arrays.stream(this.getMinorModuleKeys(stack))).map(arg_0 -> ((CompoundTag)stackTag).m_128461_(arg_0)).map(arg_0 -> ((ItemUpgradeRegistry)ItemUpgradeRegistry.instance).getModule(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @OnlyIn(value=Dist.CLIENT)
    public GuiModuleOffsets getMajorGuiOffsets(ItemStack itemStack) {
        return majorOffsets;
    }

    @OnlyIn(value=Dist.CLIENT)
    public GuiModuleOffsets getMinorGuiOffsets(ItemStack itemStack) {
        return minorOffsets;
    }

    public ItemStack getStack() {
        return new ItemStack((ItemLike)instance);
    }

    public boolean canEquipFromUse(SlotContext slotContext) {
        return true;
    }

    public boolean canSync(SlotContext slotContext) {
        return true;
    }

    public boolean canEquip(SlotContext slotContext) {
        return true;
    }

    public abstract boolean canEquipFromUse(SlotContext var1, ItemStack var2);
}

