/*
 * Decompiled with CFR 0.152.
 */
package com.tetra_loopback.effects.curio;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.SweepingEffect;
import se.mickelus.tetra.items.modular.ModularItem;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

@ParametersAreNonnullByDefault
@Mod.EventBusSubscriber
public class truesweep {
    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player attacker = (Player)entity;
            truesweep.checkAndTriggerTruesweep(attacker);
        }
    }

    private static void checkAndTriggerTruesweep(Player player) {
        if (player.m_36403_(0.5f) > 0.9f && player.m_20096_() && !player.m_20142_() && !player.getPersistentData().m_128441_("ProcessingTruesweep")) {
            player.getPersistentData().m_128379_("ProcessingTruesweep", true);
            try {
                truesweep.getTruesweepItems(player).ifPresent(items -> items.forEach(itemStack -> SweepingEffect.truesweep((ItemStack)itemStack, (LivingEntity)player, (boolean)false)));
            }
            finally {
                player.getPersistentData().m_128473_("ProcessingTruesweep");
            }
        }
    }

    private static Optional<List<ItemStack>> getTruesweepItems(Player player) {
        ArrayList validStacks = new ArrayList();
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(inv -> inv.getCurios().forEach((identifier, stacksHandler) -> {
            int i;
            IDynamicStackHandler stacks = stacksHandler.getStacks();
            IDynamicStackHandler cosmetics = stacksHandler.getCosmeticStacks();
            for (i = 0; i < stacks.getSlots(); ++i) {
                ItemStack stack = stacks.getStackInSlot(i);
                if (!truesweep.isValidTruesweepStack(stack)) continue;
                validStacks.add(stack);
            }
            for (i = 0; i < cosmetics.getSlots(); ++i) {
                ItemStack cosmetic = cosmetics.getStackInSlot(i);
                if (!truesweep.isValidTruesweepStack(cosmetic)) continue;
                validStacks.add(cosmetic);
            }
        }));
        return validStacks.isEmpty() ? Optional.empty() : Optional.of(validStacks);
    }

    private static boolean isValidTruesweepStack(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41720_() instanceof ModularItem && ((ModularItem)stack.m_41720_()).getEffectLevel(stack, ItemEffect.get((String)"truesweep")) > 0;
    }
}

