/*
 * Decompiled with CFR 0.152.
 */
package com.tetra_loopback.effects.curio;

import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Vector3f;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.ModularItem;
import top.theillusivec4.curios.api.CuriosApi;

@ParametersAreNonnullByDefault
@Mod.EventBusSubscriber
public class sweeping {
    private static final double BASE_RANGE = 1.0;
    private static final double RANGE_MULTIPLIER = 0.6;
    private static final float DAMAGE_MULTIPLIER = 0.125f;
    private static final float MAX_DAMAGE_FACTOR = 2.0f;
    private static final int SOUND_COOLDOWN = 500;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player attacker = (Player)entity;
            if (event.getEntity().m_19880_().contains("tetra_sweep_processed")) {
                return;
            }
            try {
                event.getEntity().m_20049_("tetra_sweep_processed");
                Optional<Integer> sweepingLevel = sweeping.getSweepingLevel(attacker);
                if (!sweepingLevel.isPresent() || sweepingLevel.get() <= 0) {
                    return;
                }
                int level = sweepingLevel.get();
                LivingEntity target = event.getEntity();
                float baseDamage = (float)attacker.m_21133_(Attributes.f_22281_);
                double efficiency = sweeping.getSweepingEfficiency(attacker);
                double totalRange = 1.0 + efficiency * 0.6;
                float damageFactor = Math.min((float)level * 0.125f, 2.0f);
                float sweepDamage = baseDamage * damageFactor;
                Vec3 lookVec = attacker.m_20154_().m_82541_();
                AABB aoeBox = sweeping.calculateAttackAABB(attacker, totalRange, lookVec);
                int validTargetCount = 0;
                for (LivingEntity entity2 : attacker.m_9236_().m_45976_(LivingEntity.class, aoeBox)) {
                    if (!sweeping.isValidTarget(entity2, attacker, target)) continue;
                    ++validTargetCount;
                    sweeping.handleSweepAttack(attacker, entity2, sweepDamage, lookVec);
                }
                if (validTargetCount > 0 && !attacker.m_9236_().f_46443_) {
                    sweeping.playSweepEffects((ServerLevel)attacker.m_9236_(), target, attacker);
                }
            }
            finally {
                event.getEntity().m_20137_("tetra_sweep_processed");
            }
        }
    }

    private static AABB calculateAttackAABB(Player attacker, double range, Vec3 direction) {
        Vec3 startPos = attacker.m_20182_().m_82520_(0.0, (double)attacker.m_20192_() * 0.5, 0.0).m_82549_(direction.m_82490_(1.5));
        return new AABB(startPos, startPos).m_82377_(range, 0.4, range).m_82369_(direction.m_82490_(range * 0.8));
    }

    private static boolean isValidTarget(LivingEntity entity, Player attacker, LivingEntity mainTarget) {
        return entity != attacker && (entity == mainTarget || !attacker.m_7307_((Entity)entity)) && attacker.m_142582_((Entity)entity) && attacker.m_20280_((Entity)entity) < 36.0;
    }

    private static void handleSweepAttack(Player attacker, LivingEntity target, float damage, Vec3 direction) {
        sweeping.applyKnockback(target, attacker.m_146908_(), 0.5f);
        DamageSource damageSource = attacker.m_269291_().m_269075_(attacker);
        target.m_6469_(damageSource, damage);
    }

    private static void applyKnockback(LivingEntity target, float yRot, float strength) {
        float radians = yRot * ((float)Math.PI / 180);
        target.m_147240_((double)strength, (double)Mth.m_14031_((float)radians), (double)(-Mth.m_14089_((float)radians)));
    }

    private static void playSweepEffects(ServerLevel level, LivingEntity target, Player attacker) {
        Optional<Integer> sweepingLevel = sweeping.getSweepingLevel(attacker);
        if (!sweepingLevel.isPresent() || sweepingLevel.get() <= 0) {
            return;
        }
        long lastSound = attacker.getPersistentData().m_128454_("LastSweepSound");
        long now = System.currentTimeMillis();
        if (now - lastSound > 500L) {
            level.m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 0.8f, 0.9f + attacker.m_217043_().m_188501_() * 0.2f);
            attacker.getPersistentData().m_128356_("LastSweepSound", now);
        }
        Vec3 pos = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() * 0.5, 0.0);
        level.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.9f, 0.8f, 0.3f), 1.0f), pos.f_82479_, pos.f_82480_, pos.f_82481_, 5, 0.3, 0.2, 0.3, 0.02);
    }

    private static Optional<Integer> getSweepingLevel(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> stack.m_41720_() instanceof ModularItem && ((ModularItem)stack.m_41720_()).getEffectLevel(stack, ItemEffect.get((String)"sweeping")) > 0)).map(list -> list.stream().mapToInt(curio -> ((ModularItem)curio.stack().m_41720_()).getEffectLevel(curio.stack(), ItemEffect.get((String)"sweeping"))).sum());
    }

    private static double getSweepingEfficiency(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> stack.m_41720_() instanceof ModularItem && ((ModularItem)stack.m_41720_()).getEffectLevel(stack, ItemEffect.get((String)"sweeping")) > 0)).map(list -> list.stream().mapToDouble(curio -> ((ModularItem)curio.stack().m_41720_()).getEffectEfficiency(curio.stack(), ItemEffect.get((String)"sweeping"))).sum()).orElse(0.0);
    }
}

