/*
 * Decompiled with CFR 0.152.
 */
package com.tetra_loopback.effects.curio;

import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.potion.StunPotionEffect;
import se.mickelus.tetra.items.modular.ModularItem;
import top.theillusivec4.curios.api.CuriosApi;

@ParametersAreNonnullByDefault
@Mod.EventBusSubscriber
public class stun {
    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player attacker = (Player)entity;
            stun.getStunLevel(attacker).ifPresent(level -> {
                if (attacker.m_217043_().m_188501_() < (float)level.intValue() / 100.0f) {
                    LivingEntity target = event.getEntity();
                    int duration = stun.getStunEfficiency(attacker) * 20;
                    target.m_7292_(new MobEffectInstance((MobEffect)StunPotionEffect.instance, duration, 0, false, false));
                    if (!target.m_9236_().f_46443_) {
                        ServerLevel serverLevel = (ServerLevel)target.m_9236_();
                        serverLevel.m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12316_, SoundSource.PLAYERS, 0.8f, 0.9f);
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123811_, target.m_20185_(), target.m_20188_(), target.m_20189_(), 5, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            });
        }
    }

    private static Optional<Integer> getStunLevel(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> stack.m_41720_() instanceof ModularItem && ((ModularItem)stack.m_41720_()).getEffectLevel(stack, ItemEffect.get((String)"stun")) > 0)).map(list -> list.stream().mapToInt(curio -> ((ModularItem)curio.stack().m_41720_()).getEffectLevel(curio.stack(), ItemEffect.get((String)"stun"))).sum());
    }

    private static int getStunEfficiency(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> stack.m_41720_() instanceof ModularItem && ((ModularItem)stack.m_41720_()).getEffectLevel(stack, ItemEffect.get((String)"stun")) > 0)).map(list -> list.stream().mapToInt(curio -> (int)((ModularItem)curio.stack().m_41720_()).getEffectEfficiency(curio.stack(), ItemEffect.get((String)"stun"))).sum()).orElse(0);
    }
}

