/*
 * Decompiled with CFR 0.152.
 */
package com.tetra_loopback.effects.curio;

import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.ModularItem;
import top.theillusivec4.curios.api.CuriosApi;

@ParametersAreNonnullByDefault
@Mod.EventBusSubscriber
public class reaching {
    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player attacker = (Player)entity;
            reaching.getReachingLevel(attacker).ifPresent(level -> {
                float multiplier;
                Vec3 attackerPos = attacker.m_20182_();
                Vec3 targetPos = event.getEntity().m_20182_();
                double distance = attackerPos.m_82557_(targetPos);
                float f = multiplier = event.getSource().m_269533_(DamageTypeTags.f_268524_) ? attacker.m_36403_(0.5f) : 1.0f;
                if (distance > 1.0) {
                    float damageMultiplier = reaching.getMultiplier(level, distance, multiplier);
                    event.setAmount(event.getAmount() * damageMultiplier);
                }
            });
        }
    }

    private static Optional<Integer> getReachingLevel(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> stack.m_41720_() instanceof ModularItem && ((ModularItem)stack.m_41720_()).getEffectLevel(stack, ItemEffect.get((String)"reaching")) > 0)).map(list -> list.stream().mapToInt(curio -> ((ModularItem)curio.stack().m_41720_()).getEffectLevel(curio.stack(), ItemEffect.get((String)"reaching"))).sum());
    }

    private static float getMultiplier(int level, double squareDistance, float offsetMultiplier) {
        return level > 0 && squareDistance > 0.0 ? 1.0f + reaching.getOffset(level, squareDistance) * offsetMultiplier : 1.0f;
    }

    private static float getOffset(int level, double squareDistance) {
        return (float)((double)((float)level / 100.0f) * Math.log(squareDistance * squareDistance));
    }
}

