/*
 * Decompiled with CFR 0.152.
 */
package com.tetra_loopback.effects.curio;

import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.ModularItem;
import top.theillusivec4.curios.api.CuriosApi;

@ParametersAreNonnullByDefault
@Mod.EventBusSubscriber
public class fierySelf {
    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Player attacker;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player && !(attacker = (Player)entity).m_9236_().m_5776_()) {
            Optional.ofNullable(CuriosApi.getCuriosInventory((LivingEntity)attacker)).ifPresent(inv -> fierySelf.processFierySelfEffect(attacker, 1.0));
        }
    }

    private static void processFierySelfEffect(Player player, double multiplier) {
        if (player.m_9236_().m_5776_()) {
            return;
        }
        List curios = CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> stack.m_41720_() instanceof ModularItem && EffectHelper.getEffectLevel((ItemStack)stack, (ItemEffect)ItemEffect.get((String)"fierySelf")) > 0)).orElse(List.of());
        if (!curios.isEmpty()) {
            double totalEfficiency = curios.stream().mapToDouble(curio -> EffectHelper.getEffectEfficiency((ItemStack)curio.stack(), (ItemEffect)ItemEffect.get((String)"fierySelf"))).sum();
            int totalLevel = curios.stream().mapToInt(curio -> EffectHelper.getEffectLevel((ItemStack)curio.stack(), (ItemEffect)ItemEffect.get((String)"fierySelf"))).sum();
            BlockPos pos = player.m_20183_();
            float temperature = fierySelf.getBiomeTemperature(player, pos);
            double chance = totalEfficiency * (double)temperature * multiplier;
            if (player.m_217043_().m_188500_() < chance) {
                player.m_20254_(totalLevel);
            }
        }
    }

    private static float getBiomeTemperature(Player player, BlockPos pos) {
        return ((Biome)player.m_9236_().m_204166_(pos).m_203334_()).m_47554_();
    }
}

