/*
 * Decompiled with CFR 0.152.
 */
package com.tetra_loopback.effects.curio;

import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.potion.EarthboundPotionEffect;
import se.mickelus.tetra.items.modular.ModularItem;
import top.theillusivec4.curios.api.CuriosApi;

@ParametersAreNonnullByDefault
@Mod.EventBusSubscriber
public class earthbind {
    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player attacker = (Player)entity;
            int totalLevel = earthbind.getCombinedEarthbindLevel(attacker);
            LivingEntity target = event.getEntity();
            Level world = target.m_20193_();
            if (totalLevel > 0 && (double)attacker.m_217043_().m_188501_() < Math.max(0.1, 0.5 * (1.0 - target.m_20186_() / 128.0))) {
                target.m_7292_(new MobEffectInstance((MobEffect)EarthboundPotionEffect.instance, totalLevel * 20, 0, false, true));
                if (world instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)world;
                    BlockState blockState = world.m_8055_(target.m_20183_().m_7495_());
                    serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), target.m_20185_(), target.m_20186_() + 0.1, target.m_20189_(), 16, 0.0, world.m_213780_().m_188583_() * 0.2, 0.0, 0.1);
                }
            }
        }
    }

    private static int getCombinedEarthbindLevel(Player player) {
        return earthbind.getCurioEarthbindLevel(player) + earthbind.getWeaponEarthbindLevel(player);
    }

    private static int getCurioEarthbindLevel(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> stack.m_41720_() instanceof ModularItem && ((ModularItem)stack.m_41720_()).getEffectLevel(stack, ItemEffect.earthbind) > 0)).map(list -> list.stream().mapToInt(curio -> ((ModularItem)curio.stack().m_41720_()).getEffectLevel(curio.stack(), ItemEffect.earthbind)).sum()).orElse(0);
    }

    private static int getWeaponEarthbindLevel(Player player) {
        return Optional.of(player.m_21205_()).filter(stack -> stack.m_41720_() instanceof ModularItem).map(stack -> ((ModularItem)stack.m_41720_()).getEffectLevel(stack, ItemEffect.earthbind)).orElse(0);
    }
}

