/*
 * Decompiled with CFR 0.152.
 */
package com.tetra_loopback.effects.curio;

import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.ModularItem;
import top.theillusivec4.curios.api.CuriosApi;

@ParametersAreNonnullByDefault
@Mod.EventBusSubscriber
public class criticalStrike {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onCriticalHit(CriticalHitEvent event) {
        Player player = event.getEntity();
        if (event.isCanceled()) {
            return;
        }
        criticalStrike.getCriticalStrikeLevel(player).ifPresent(totalLevel -> {
            if (player.m_217043_().m_188501_() < (float)totalLevel.intValue() * 0.01f) {
                ItemStack mainHand = player.m_21205_();
                float critMultiplier = 2.0f;
                Item patt1522$temp = mainHand.m_41720_();
                if (patt1522$temp instanceof ModularItem) {
                    ModularItem modularItem = (ModularItem)patt1522$temp;
                    critMultiplier = modularItem.getEffectEfficiency(mainHand, ItemEffect.criticalStrike);
                }
                event.setDamageModifier(Math.max(critMultiplier, event.getDamageModifier()));
                event.setResult(Event.Result.ALLOW);
                if (!player.m_9236_().m_5776_()) {
                    ServerLevel serverLevel = (ServerLevel)player.m_9236_();
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, event.getTarget().m_20185_(), event.getTarget().m_20186_() + (double)(event.getTarget().m_20206_() / 2.0f), event.getTarget().m_20189_(), 15, 0.5, 0.5, 0.5, 0.3);
                }
            }
        });
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        LevelAccessor levelAccess = event.getLevel();
        if (levelAccess.m_5776_()) {
            return;
        }
        criticalStrike.getCriticalStrikeLevel(player).ifPresent(totalLevel -> {
            if (player.m_217043_().m_188501_() < (float)totalLevel.intValue() * 0.01f) {
                ServerLevel serverLevel = (ServerLevel)levelAccess;
                BlockPos pos = event.getPos();
                serverLevel.m_46953_(pos, true, (Entity)player);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123808_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 20, (serverLevel.f_46441_.m_188500_() * 2.0 - 1.0) * 0.5, 0.5 + serverLevel.f_46441_.m_188500_() * 0.5, (serverLevel.f_46441_.m_188500_() * 2.0 - 1.0) * 0.5, 0.5);
                event.setCanceled(true);
            }
        });
    }

    private static Optional<Integer> getCriticalStrikeLevel(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> {
            if (stack.m_41720_() instanceof ModularItem) {
                ModularItem item = (ModularItem)stack.m_41720_();
                return item.getEffectLevel(stack, ItemEffect.get((String)"criticalStrike")) > 0;
            }
            return false;
        })).map(list -> list.stream().mapToInt(curio -> {
            ModularItem item = (ModularItem)curio.stack().m_41720_();
            return item.getEffectLevel(curio.stack(), ItemEffect.get((String)"criticalStrike"));
        }).sum());
    }
}

