/*
 * Decompiled with CFR 0.152.
 */
package com.tetra_loopback.effects.curio;

import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.IModularItem;
import top.theillusivec4.curios.api.CuriosApi;

@ParametersAreNonnullByDefault
@Mod.EventBusSubscriber
public class backstab {
    private static final float BASE_DAMAGE_MULTIPLIER = 1.25f;
    private static final float LEVEL_BONUS = 0.25f;
    private static final float BASE_ANGLE_THRESHOLD = 60.0f;
    private static final float ANGLE_REDUCTION_PER_LEVEL = 5.0f;
    private static final float MIN_ANGLE_THRESHOLD = 15.0f;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLivingHurt(LivingHurtEvent event) {
        if (event.getSource().m_7639_() == null || !(event.getSource().m_7639_() instanceof Player)) {
            return;
        }
        Player attacker = (Player)event.getSource().m_7639_();
        if (attacker.m_9236_().m_5776_()) {
            return;
        }
        int backstabLevel = backstab.getCurioBackstabLevel(attacker);
        if (backstabLevel <= 0) {
            return;
        }
        LivingEntity target = event.getEntity();
        float threshold = backstab.calculateAngleThreshold(backstabLevel);
        float actualAngle = backstab.calculateAttackAngle(attacker, target);
        if (actualAngle < threshold) {
            float originalDamage = event.getAmount();
            float damageMultiplier = 1.25f + 0.25f * (float)backstabLevel;
            float newDamage = originalDamage * damageMultiplier;
            event.setAmount(newDamage);
        }
    }

    private static int getCurioBackstabLevel(Player player) {
        Optional levelOptional = CuriosApi.getCuriosInventory((LivingEntity)player).map(inventory -> {
            List foundCurios = inventory.findCurios(stack -> {
                Item item = stack.m_41720_();
                return item instanceof IModularItem && ((IModularItem)item).getEffectLevel(stack, ItemEffect.backstab) > 0;
            });
            return foundCurios.stream().mapToInt(curio -> {
                ItemStack stack = curio.stack();
                return ((IModularItem)stack.m_41720_()).getEffectLevel(stack, ItemEffect.backstab);
            }).sum();
        });
        return levelOptional.orElse(0);
    }

    private static float calculateAngleThreshold(int level) {
        float threshold = 60.0f - 5.0f * (float)level;
        return Math.max(threshold, 15.0f);
    }

    private static float calculateAttackAngle(Player attacker, LivingEntity target) {
        float targetYaw;
        float attackerYaw = backstab.normalizeAngle(attacker.m_146908_());
        float angleDiff = Math.abs(attackerYaw - (targetYaw = backstab.normalizeAngle(target.m_146908_())));
        if (angleDiff > 180.0f) {
            angleDiff = 360.0f - angleDiff;
        }
        return angleDiff;
    }

    private static float normalizeAngle(float angle) {
        if ((angle %= 360.0f) < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }
}

