/*
 * Decompiled with CFR 0.152.
 */
package com.tetra_loopback.effects.curio;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.ModularItem;
import top.theillusivec4.curios.api.CuriosApi;

@ParametersAreNonnullByDefault
@Mod.EventBusSubscriber
public class armorPenetration {
    private static final UUID ARMOR_PEN_UUID = UUID.fromString("d7e3a8b3-5a2f-481c-911d-c8b45e3f01a5");

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            armorPenetration.getArmorPenetrationLevel(attacker).ifPresent(level -> armorPenetration.applyArmorReduction(event.getEntity(), level));
        }
    }

    private static void applyArmorReduction(LivingEntity target, int effectLevel) {
        AttributeInstance armorAttr = target.m_21051_(Attributes.f_22284_);
        if (armorAttr != null && armorAttr.m_22111_(ARMOR_PEN_UUID) == null) {
            armorAttr.m_22118_(new AttributeModifier(ARMOR_PEN_UUID, "curio_armor_pen", (double)effectLevel * -0.01, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity target = event.getEntity();
        AttributeInstance armorAttr = target.m_21051_(Attributes.f_22284_);
        if (armorAttr != null) {
            armorAttr.m_22120_(ARMOR_PEN_UUID);
        }
    }

    private static Optional<Integer> getArmorPenetrationLevel(LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).map(inv -> inv.findCurios(stack -> stack.m_41720_() instanceof ModularItem && ((ModularItem)stack.m_41720_()).getEffectLevel(stack, ItemEffect.get((String)"armorPenetration")) > 0)).map(list -> list.stream().mapToInt(curio -> ((ModularItem)curio.stack().m_41720_()).getEffectLevel(curio.stack(), ItemEffect.get((String)"armorPenetration"))).sum());
    }
}

