/*
 * Decompiled with CFR 0.152.
 */
package com.tetra_loopback.effects.curio;

import com.tetra_loopback.effects.gui.ModEffectStats;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import se.mickelus.tetra.items.modular.ModularItem;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="tetra_loopback")
public class StrifeEffect {
    private static final Map<UUID, Long> cooldowns = new ConcurrentHashMap<UUID, Long>();
    private static final int BUFF_DURATION = 200;
    private static final int COOLDOWN = 400;

    @SubscribeEvent
    public static void onAttack(LivingAttackEvent event) {
        Player attacker;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player && StrifeEffect.hasEffect(attacker = (Player)entity)) {
            LivingEntity target = event.getEntity();
            if (target instanceof Monster) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200, 1));
            } else {
                attacker.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200, 1));
            }
        }
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && StrifeEffect.hasEffect(player = (Player)livingEntity) && !player.m_9236_().m_5776_()) {
            long currentTime = player.m_9236_().m_46467_();
            Long lastTrigger = cooldowns.get(player.m_20148_());
            if (lastTrigger == null || currentTime - lastTrigger >= 400L) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 200, 2));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200, 1));
                cooldowns.put(player.m_20148_(), currentTime);
            }
        }
    }

    private static boolean hasEffect(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> stack.m_41720_() instanceof ModularItem && ((ModularItem)stack.m_41720_()).getEffectLevel(stack, ModEffectStats.strifeEffect) > 0)).map(list -> !list.isEmpty()).orElse(false);
    }
}

