/*
 * Decompiled with CFR 0.152.
 */
package com.tetra_loopback.effects.curio;

import com.tetra_loopback.effects.gui.ModEffectStats;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import se.mickelus.tetra.items.modular.ModularItem;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="tetra_loopback")
public class RuneCreedEffect {
    private static final UUID ARMOR_UUID = UUID.fromString("d9aae8a1-1234-5678-9abc-def012345682");
    private static final UUID ATTACK_UUID = UUID.fromString("d9aae8a1-1234-5678-9abc-def012345683");
    private static final Map<UUID, Integer> lastArmorEnchants = new HashMap<UUID, Integer>();
    private static final Map<UUID, Integer> lastAttackEnchants = new HashMap<UUID, Integer>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().f_46443_) {
            return;
        }
        Player player = event.player;
        if (!RuneCreedEffect.hasEffect(player)) {
            RuneCreedEffect.clearModifiers(player);
            return;
        }
        if (player.f_19797_ % 5 == 0) {
            RuneCreedEffect.updateArmorBonus(player);
            RuneCreedEffect.updateAttackBonus(player);
        }
    }

    private static void updateArmorBonus(Player player) {
        AtomicInteger totalEnchants = new AtomicInteger();
        Arrays.stream(EquipmentSlot.values()).filter(slot -> slot.m_20743_() == EquipmentSlot.Type.ARMOR).map(arg_0 -> ((Player)player).m_6844_(arg_0)).forEach(stack -> totalEnchants.addAndGet(EnchantmentHelper.m_44831_((ItemStack)stack).size()));
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(inv -> inv.getCurios().values().forEach(stacksHandler -> {
            for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                ItemStack stack = stacksHandler.getStacks().getStackInSlot(i);
                totalEnchants.addAndGet(EnchantmentHelper.m_44831_((ItemStack)stack).size());
            }
        }));
        double armorValue = (double)totalEnchants.get() * 0.5;
        RuneCreedEffect.applyModifier(player, Attributes.f_22284_, ARMOR_UUID, "rune_armor", armorValue, AttributeModifier.Operation.ADDITION);
        lastArmorEnchants.put(player.m_20148_(), totalEnchants.get());
    }

    private static void updateAttackBonus(Player player) {
        ItemStack mainHand = player.m_21205_();
        int enchants = EnchantmentHelper.m_44831_((ItemStack)mainHand).size();
        RuneCreedEffect.applyModifier(player, Attributes.f_22281_, ATTACK_UUID, "rune_attack", enchants, AttributeModifier.Operation.ADDITION);
        lastAttackEnchants.put(player.m_20148_(), enchants);
    }

    private static void applyModifier(Player player, Attribute attribute, UUID uuid, String name, double value, AttributeModifier.Operation op) {
        Objects.requireNonNull(player.m_21051_(attribute)).m_22120_(uuid);
        if (value > 0.0) {
            AttributeModifier modifier = new AttributeModifier(uuid, name, value, op);
            player.m_21051_(attribute).m_22118_(modifier);
        }
    }

    private static void clearModifiers(Player player) {
        if (lastArmorEnchants.containsKey(player.m_20148_())) {
            player.m_21051_(Attributes.f_22284_).m_22120_(ARMOR_UUID);
            lastArmorEnchants.remove(player.m_20148_());
        }
        if (lastAttackEnchants.containsKey(player.m_20148_())) {
            player.m_21051_(Attributes.f_22281_).m_22120_(ATTACK_UUID);
            lastAttackEnchants.remove(player.m_20148_());
        }
    }

    private static boolean hasEffect(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> stack.m_41720_() instanceof ModularItem && ((ModularItem)stack.m_41720_()).getEffectLevel(stack, ModEffectStats.runeCreedEffect) > 0)).map(list -> !list.isEmpty()).orElse(false);
    }
}

