/*
 * Decompiled with CFR 0.152.
 */
package com.tetra_loopback.effects.curio;

import com.tetra_loopback.effects.gui.ModEffectStats;
import java.util.UUID;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import se.mickelus.tetra.items.modular.ModularItem;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="tetra_loopback")
public class FlameAdmonitionHandler {
    private static final UUID FIRE_RESIST_UUID = UUID.fromString("d9aae8a1-1234-5678-9abc-def012345679");

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getSource().m_269533_(DamageTypeTags.f_268745_) && FlameAdmonitionHandler.hasEffect(player)) {
                event.setAmount(event.getAmount() * 0.3f);
            }
        }
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        Player player = event.getEntity();
        if (FlameAdmonitionHandler.hasEffect(player)) {
            event.getTarget().m_20254_(3);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (event.phase == TickEvent.Phase.END && !player.m_9236_().f_46443_) {
            boolean shouldHaveEffect = FlameAdmonitionHandler.hasEffect(player) && player.m_6060_();
            MobEffectInstance currentEffect = player.m_21124_(MobEffects.f_19600_);
            if (shouldHaveEffect) {
                if (currentEffect == null || currentEffect.m_19564_() < 1) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 120, 1, false, false, true));
                }
            } else if (currentEffect != null && currentEffect.m_19564_() == 1) {
                player.m_21195_(MobEffects.f_19600_);
            }
        }
    }

    private static boolean hasEffect(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(itemStack -> itemStack.m_41720_() instanceof ModularItem && ((ModularItem)itemStack.m_41720_()).getEffectLevel(itemStack, ModEffectStats.flameAdmonitionEffect) > 0)).map(list -> !list.isEmpty()).orElse(false);
    }
}

